/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.GenericTypeException;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.TypeToken;
import de.quantummaid.reflectmaid.TypeVariableName;
import de.quantummaid.reflectmaid.unresolved.UnresolvedType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class GenericType<T> {
    private final ResolvedType type;

    public static <T> GenericType<T> genericType(Class<T> type) {
        UnresolvedType unresolvedType = UnresolvedType.unresolvedType(type);
        List<TypeVariableName> typeVariableNames = unresolvedType.typeVariables();
        if (!typeVariableNames.isEmpty()) {
            String variables = typeVariableNames.stream().map(TypeVariableName::name).collect(Collectors.joining(", ", "[", "]"));
            throw GenericTypeException.genericTypeException(String.format("type '%s' contains the following type variables that need to be filled in in order to create a %s object: %s", type.getName(), GenericType.class.getSimpleName(), variables));
        }
        ResolvedType resolvedType = ResolvedType.resolvedType(type);
        return new GenericType<T>(resolvedType);
    }

    public static <T> GenericType<T> genericType(Class<?> type, Class<?> ... genericParameters) {
        GenericType[] genericParameterTypes = (GenericType[])Arrays.stream(genericParameters).map(GenericType::genericType).toArray(GenericType[]::new);
        return GenericType.genericType(type, genericParameterTypes);
    }

    public static <T> GenericType<T> genericType(Class<?> type, GenericType<?> ... genericParameters) {
        UnresolvedType unresolvedType = UnresolvedType.unresolvedType(type);
        List<ResolvedType> resolvedParameters = Arrays.stream(genericParameters).map(GenericType::toResolvedType).collect(Collectors.toList());
        ResolvedType resolvedType = unresolvedType.resolve(resolvedParameters);
        return new GenericType<T>(resolvedType);
    }

    public static <T> GenericType<T> genericType(TypeToken<T> typeToken) {
        ResolvedType resolvedType = typeToken.toResolvedType();
        return GenericType.fromResolvedType(resolvedType);
    }

    public static <T> GenericType<T> fromResolvedType(ResolvedType type) {
        return new GenericType<T>(type);
    }

    public ResolvedType toResolvedType() {
        return this.type;
    }

    @Generated
    public String toString() {
        return "GenericType(type=" + this.type + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericType)) {
            return false;
        }
        GenericType other = (GenericType)o;
        ResolvedType this$type = this.type;
        ResolvedType other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    private GenericType(ResolvedType type) {
        this.type = type;
    }
}

