/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.resolvedtype.resolver;

import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.exceptions.UnresolvableTypeVariableException;
import de.quantummaid.reflectmaid.resolvedtype.ClassType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.resolvedtype.resolver.ResolvedMethod;
import de.quantummaid.reflectmaid.resolvedtype.resolver.ResolvedParameter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J/\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0006\u0010\u0018\u001a\u00020\u0019J\u0013\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\u001c\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020\u0019J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030 J\t\u0010!\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedMethod;", "", "returnType", "Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "parameters", "", "Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedParameter;", "method", "Ljava/lang/reflect/Method;", "(Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;Ljava/util/List;Ljava/lang/reflect/Method;)V", "isPublic", "", "()Z", "isStatic", "getMethod", "()Ljava/lang/reflect/Method;", "getParameters", "()Ljava/util/List;", "getReturnType", "()Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "component1", "component2", "component3", "copy", "describe", "", "equals", "other", "hasParameters", "hashCode", "", "name", "Ljava/util/Optional;", "toString", "Companion", "reflectmaid-parent"})
public final class ResolvedMethod {
    @Nullable
    private final ResolvedType returnType;
    @NotNull
    private final List<ResolvedParameter> parameters;
    @NotNull
    private final Method method;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Optional<ResolvedType> returnType() {
        Optional<ResolvedType> optional = Optional.ofNullable(this.returnType);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"Optional.ofNullable(returnType)");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasParameters(@NotNull List<? extends ResolvedType> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (parameters.size() != this.parameters.size()) {
            return false;
        }
        int n = 0;
        int n2 = ((Collection)parameters).size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)parameters.get((int)i), (Object)this.parameters.get((int)i).getType()) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NotNull
    public final String name() {
        String string = this.method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        return string;
    }

    public final boolean isPublic() {
        int modifiers = this.method.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public final boolean isStatic() {
        int modifiers = this.method.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    @NotNull
    public final String describe() {
        String parametersString2 = this.parameters.stream().map(describe.parametersString.1.INSTANCE).collect(Collectors.joining(", "));
        String returnTypeDescription2 = Optional.ofNullable(this.returnType).map(describe.returnTypeDescription.1.INSTANCE).orElse("void");
        String name = this.method.getName();
        String fullSignature = this.method.toGenericString();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "'%s %s(%s)' [%s]";
        Object[] objectArray = new Object[]{returnTypeDescription2, name, parametersString2, fullSignature};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @Nullable
    public final ResolvedType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final List<ResolvedParameter> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    public ResolvedMethod(@Nullable ResolvedType returnType, @NotNull List<ResolvedParameter> parameters, @NotNull Method method) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.returnType = returnType;
        this.parameters = parameters;
        this.method = method;
    }

    @Nullable
    public final ResolvedType component1() {
        return this.returnType;
    }

    @NotNull
    public final List<ResolvedParameter> component2() {
        return this.parameters;
    }

    @NotNull
    public final Method component3() {
        return this.method;
    }

    @NotNull
    public final ResolvedMethod copy(@Nullable ResolvedType returnType, @NotNull List<ResolvedParameter> parameters, @NotNull Method method) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return new ResolvedMethod(returnType, parameters, method);
    }

    public static /* synthetic */ ResolvedMethod copy$default(ResolvedMethod resolvedMethod, ResolvedType resolvedType, List list, Method method, int n, Object object) {
        if ((n & 1) != 0) {
            resolvedType = resolvedMethod.returnType;
        }
        if ((n & 2) != 0) {
            list = resolvedMethod.parameters;
        }
        if ((n & 4) != 0) {
            method = resolvedMethod.method;
        }
        return resolvedMethod.copy(resolvedType, list, method);
    }

    @NotNull
    public String toString() {
        return "ResolvedMethod(returnType=" + this.returnType + ", parameters=" + this.parameters + ", method=" + this.method + ")";
    }

    public int hashCode() {
        ResolvedType resolvedType = this.returnType;
        List<ResolvedParameter> list = this.parameters;
        Method method = this.method;
        return ((resolvedType != null ? resolvedType.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (method != null ? ((Object)method).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ResolvedMethod)) break block3;
                ResolvedMethod resolvedMethod = (ResolvedMethod)object;
                if (!Intrinsics.areEqual((Object)this.returnType, (Object)resolvedMethod.returnType) || !Intrinsics.areEqual(this.parameters, resolvedMethod.parameters) || !Intrinsics.areEqual((Object)this.method, (Object)resolvedMethod.method)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final List<ResolvedMethod> resolveMethodsWithResolvableTypeVariables(@NotNull ReflectMaid reflectMaid, @NotNull ClassType fullType) {
        return Companion.resolveMethodsWithResolvableTypeVariables(reflectMaid, fullType);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedMethod$Companion;", "", "()V", "resolveMethod", "Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedMethod;", "reflectMaid", "Lde/quantummaid/reflectmaid/ReflectMaid;", "method", "Ljava/lang/reflect/Method;", "context", "Lde/quantummaid/reflectmaid/resolvedtype/ClassType;", "resolveMethodsWithResolvableTypeVariables", "", "fullType", "reflectmaid-parent"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<ResolvedMethod> resolveMethodsWithResolvableTypeVariables(@NotNull ReflectMaid reflectMaid, @NotNull ClassType fullType) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)reflectMaid, (String)"reflectMaid");
            Intrinsics.checkNotNullParameter((Object)fullType, (String)"fullType");
            Class<?> type = fullType.assignableType();
            Method[] methodArray = type.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"type.declaredMethods");
            Method[] methodArray2 = methodArray;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var9_9 = $this$filterTo$iv$iv;
            int n = ((void)var9_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var9_9[i];
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (!(!v1.isSynthetic())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ResolvedMethod resolvedMethod;
                ResolvedMethod resolvedMethod2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Method it = (Method)element$iv$iv;
                boolean bl2 = false;
                try {
                    Method method = it;
                    Intrinsics.checkNotNullExpressionValue((Object)method, (String)"it");
                    resolvedMethod2 = Companion.resolveMethod(reflectMaid, method, fullType);
                }
                catch (UnresolvableTypeVariableException e) {
                    resolvedMethod2 = null;
                }
                if (resolvedMethod2 == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ResolvedMethod it$iv$iv = resolvedMethod;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final ResolvedMethod resolveMethod(@NotNull ReflectMaid reflectMaid, @NotNull Method method, @NotNull ClassType context) {
            ResolvedType resolvedType;
            Intrinsics.checkNotNullParameter((Object)reflectMaid, (String)"reflectMaid");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Type genericReturnType = method.getGenericReturnType();
            List<ResolvedParameter> parameters = ResolvedParameter.Companion.resolveParameters(reflectMaid, method, context);
            if (genericReturnType != Void.TYPE) {
                Type type = genericReturnType;
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"genericReturnType");
                resolvedType = reflectMaid.resolve(GenericType.Companion.fromReflectionType(type, context));
            } else {
                resolvedType = null;
            }
            ResolvedType returnType = resolvedType;
            return new ResolvedMethod(returnType, parameters, method);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

