/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.resolvedtype.resolver;

import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ClassType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.resolvedtype.resolver.ResolvedField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0006\u0010\u0018\u001a\u00020\u0003J\u0013\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedField;", "", "name", "", "type", "Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "field", "Ljava/lang/reflect/Field;", "(Ljava/lang/String;Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;Ljava/lang/reflect/Field;)V", "getField", "()Ljava/lang/reflect/Field;", "isPublic", "", "()Z", "isStatic", "isTransient", "getName", "()Ljava/lang/String;", "getType", "()Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "component1", "component2", "component3", "copy", "describe", "equals", "other", "hashCode", "", "toString", "Companion", "reflectmaid-parent"})
public final class ResolvedField {
    @NotNull
    private final String name;
    @NotNull
    private final ResolvedType type;
    @NotNull
    private final Field field;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isPublic() {
        int modifiers = this.field.getModifiers();
        return Modifier.isPublic(modifiers);
    }

    public final boolean isStatic() {
        int modifiers = this.field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public final boolean isTransient() {
        int modifiers = this.field.getModifiers();
        return Modifier.isTransient(modifiers);
    }

    @NotNull
    public final String describe() {
        StringJoiner joiner = new StringJoiner(" ");
        int modifiers = this.field.getModifiers();
        if (this.isPublic()) {
            joiner.add("public");
        }
        if (Modifier.isProtected(modifiers)) {
            joiner.add("protected");
        }
        if (Modifier.isPrivate(modifiers)) {
            joiner.add("private");
        }
        if (this.isStatic()) {
            joiner.add("static");
        }
        if (this.isTransient()) {
            joiner.add("transient");
        }
        if (Modifier.isFinal(modifiers)) {
            joiner.add("final");
        }
        String typeDescription = this.type.simpleDescription();
        joiner.add(typeDescription);
        joiner.add(this.name);
        String string = joiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joiner.toString()");
        return string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ResolvedType getType() {
        return this.type;
    }

    @NotNull
    public final Field getField() {
        return this.field;
    }

    public ResolvedField(@NotNull String name, @NotNull ResolvedType type, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.name = name;
        this.type = type;
        this.field = field;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final ResolvedType component2() {
        return this.type;
    }

    @NotNull
    public final Field component3() {
        return this.field;
    }

    @NotNull
    public final ResolvedField copy(@NotNull String name, @NotNull ResolvedType type, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return new ResolvedField(name, type, field);
    }

    public static /* synthetic */ ResolvedField copy$default(ResolvedField resolvedField, String string, ResolvedType resolvedType, Field field, int n, Object object) {
        if ((n & 1) != 0) {
            string = resolvedField.name;
        }
        if ((n & 2) != 0) {
            resolvedType = resolvedField.type;
        }
        if ((n & 4) != 0) {
            field = resolvedField.field;
        }
        return resolvedField.copy(string, resolvedType, field);
    }

    @NotNull
    public String toString() {
        return "ResolvedField(name=" + this.name + ", type=" + this.type + ", field=" + this.field + ")";
    }

    public int hashCode() {
        String string = this.name;
        ResolvedType resolvedType = this.type;
        Field field = this.field;
        return ((string != null ? string.hashCode() : 0) * 31 + (resolvedType != null ? resolvedType.hashCode() : 0)) * 31 + (field != null ? ((Object)field).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ResolvedField)) break block3;
                ResolvedField resolvedField = (ResolvedField)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)resolvedField.name) || !Intrinsics.areEqual((Object)this.type, (Object)resolvedField.type) || !Intrinsics.areEqual((Object)this.field, (Object)resolvedField.field)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final List<ResolvedField> resolvedFields(@NotNull ReflectMaid reflectMaid, @NotNull ClassType fullType) {
        return Companion.resolvedFields(reflectMaid, fullType);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedField$Companion;", "", "()V", "resolvedField", "Lde/quantummaid/reflectmaid/resolvedtype/resolver/ResolvedField;", "name", "", "type", "Lde/quantummaid/reflectmaid/resolvedtype/ResolvedType;", "field", "Ljava/lang/reflect/Field;", "resolvedFields", "", "reflectMaid", "Lde/quantummaid/reflectmaid/ReflectMaid;", "fullType", "Lde/quantummaid/reflectmaid/resolvedtype/ClassType;", "reflectmaid-parent"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final List<ResolvedField> resolvedFields(@NotNull ReflectMaid reflectMaid, @NotNull ClassType fullType) {
            Intrinsics.checkNotNullParameter((Object)reflectMaid, (String)"reflectMaid");
            Intrinsics.checkNotNullParameter((Object)fullType, (String)"fullType");
            Class<?> type = fullType.assignableType();
            List<ResolvedField> list = Arrays.stream(type.getDeclaredFields()).filter(resolvedFields.1.INSTANCE).map((Function)new Function<Field, ResolvedField>(reflectMaid, fullType){
                final /* synthetic */ ReflectMaid $reflectMaid;
                final /* synthetic */ ClassType $fullType;

                public final ResolvedField apply(@NotNull Field field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    Type type = field.getGenericType();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"field.genericType");
                    ResolvedType resolved = this.$reflectMaid.resolve(GenericType.Companion.fromReflectionType(type, this.$fullType));
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                    return de.quantummaid.reflectmaid.resolvedtype.resolver.ResolvedField$Companion.access$resolvedField(ResolvedField.Companion, string, resolved, field);
                }
                {
                    this.$reflectMaid = reflectMaid;
                    this.$fullType = classType;
                }
            }).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"Arrays.stream(type.decla\u2026lect(Collectors.toList())");
            return list;
        }

        private final ResolvedField resolvedField(String name, ResolvedType type, Field field) {
            return new ResolvedField(name, type, field);
        }

        private Companion() {
        }

        public static final /* synthetic */ ResolvedField access$resolvedField(Companion $this, String name, ResolvedType type, Field field) {
            return $this.resolvedField(name, type, field);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

