/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.allure;

import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AllureTestResultGenerator {
    public static List<TestResult> fromQtafTestSuiteCollection(TestSuiteLogCollection collection) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestFeatureLogCollection feature : collection.getTestFeatureLogCollections()) {
            for (TestScenarioLogCollection scenario : feature.getScenarioLogCollection()) {
                testResults.add(AllureTestResultGenerator.fromQtafTestScenario(scenario));
            }
        }
        return testResults;
    }

    public static TestResult fromQtafTestScenario(TestScenarioLogCollection scenario) {
        List<StepResult> testResultSteps = AllureTestResultGenerator.getStepResultsFromQtafScenario(scenario);
        List<Attachment> testResultAttachments = AllureTestResultGenerator.getAllureTestResultAttachments(scenario);
        ArrayList testResultParameters = new ArrayList();
        ArrayList testResultLabels = new ArrayList();
        ArrayList testResultLinks = new ArrayList();
        StatusDetails statusDetails = new StatusDetails().setKnown(false).setMuted(false).setFlaky(false).setMessage("").setTrace("");
        return new TestResult().setUuid(UUID.randomUUID().toString()).setHistoryId(scenario.getScenarioId()).setFullName(scenario.getScenarioId()).setLabels(testResultLabels).setLinks(testResultLinks).setName(scenario.getDescription()).setStatus(AllureTestResultGenerator.mapQtafScenarioStatusToAllureTestResultStatus(scenario.getStatus())).setStatusDetails(statusDetails).setStage(Stage.FINISHED).setSteps(testResultSteps).setAttachments(testResultAttachments).setParameters(testResultParameters).setDescriptionHtml(null).setStart(Long.valueOf(scenario.getStart().getTime())).setStop(Long.valueOf(scenario.getEnd().getTime()));
    }

    public static List<StepResult> getStepResultsFromQtafScenario(TestScenarioLogCollection scenario) {
        ArrayList logMessages = scenario.getLogMessages();
        ArrayList<StepResult> stepResults = new ArrayList<StepResult>();
        for (LogMessage logMessage : logMessages) {
            StepInformationLogMessage stepLog = (StepInformationLogMessage)logMessage;
            List<Parameter> stepParameters = AllureTestResultGenerator.getStepResultParameters(stepLog);
            StatusDetails statusDetails = AllureTestResultGenerator.getAllureStepResultStatusDetailsFromQtafStep(stepLog);
            StepResult stepResult = new StepResult().setName(stepLog.getStep().getName()).setDescription(stepLog.getStep().getDescription()).setStart(Long.valueOf(stepLog.getStart().getTime())).setStop(Long.valueOf(stepLog.getEnd().getTime())).setParameters(stepParameters).setDescriptionHtml(null).setStage(AllureTestResultGenerator.getStepStageFromQtafStep(stepLog)).setStatus(AllureTestResultGenerator.getStepStatusFromQtafStep(stepLog)).setStatusDetails(statusDetails).setAttachments(AllureTestResultGenerator.getAllureStepResultAttachments(stepLog)).setSteps(null);
            stepResults.add(stepResult);
        }
        return stepResults;
    }

    private static StatusDetails getAllureStepResultStatusDetailsFromQtafStep(StepInformationLogMessage stepLog) {
        StatusDetails statusDetails = new StatusDetails().setTrace(stepLog.getMessage()).setMessage("").setMuted(false).setKnown(false).setFlaky(false);
        return statusDetails;
    }

    public static Stage getStepStageFromQtafStep(StepInformationLogMessage stepLog) {
        return switch (stepLog.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case StepInformationLogMessage.Status.PASS, StepInformationLogMessage.Status.ERROR, StepInformationLogMessage.Status.SKIPPED, StepInformationLogMessage.Status.UNDEFINED -> Stage.FINISHED;
            case StepInformationLogMessage.Status.PENDING -> Stage.PENDING;
        };
    }

    public static Status getStepStatusFromQtafStep(StepInformationLogMessage stepLog) {
        return switch (stepLog.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case StepInformationLogMessage.Status.PASS -> Status.PASSED;
            case StepInformationLogMessage.Status.SKIPPED, StepInformationLogMessage.Status.PENDING -> Status.SKIPPED;
            case StepInformationLogMessage.Status.ERROR -> Status.FAILED;
            case StepInformationLogMessage.Status.UNDEFINED -> Status.BROKEN;
        };
    }

    public static List<Parameter> getStepResultParameters(StepInformationLogMessage stepLog) {
        ArrayList<Parameter> stepParameters = new ArrayList<Parameter>();
        for (StepInformationLogMessage.StepParameter stepParameter : stepLog.getStepParameters()) {
            Parameter parameter = new Parameter().setName(stepParameter.getName()).setExcluded(Boolean.valueOf(true)).setValue(stepParameter.getValue().toString()).setMode(Parameter.Mode.DEFAULT);
            stepParameters.add(parameter);
        }
        return stepParameters;
    }

    public static List<Attachment> getAllureTestResultAttachments(TestScenarioLogCollection scenarioLogCollection) {
        Attachment beforeScreenshot = new Attachment().setName("Before Scenario").setType("image/png").setSource(scenarioLogCollection.getScreenshotBefore());
        Attachment afterScreenshot = new Attachment().setName("After Scenario").setType("image/png").setSource(scenarioLogCollection.getScreenshotAfter());
        return List.of(beforeScreenshot, afterScreenshot);
    }

    public static List<Attachment> getAllureStepResultAttachments(StepInformationLogMessage stepLog) {
        Attachment beforeScreenshot = new Attachment().setName("Before Step").setType("image/png").setSource(stepLog.getScreenshotBefore());
        Attachment afterScreenshot = new Attachment().setName("After Step").setType("image/png").setSource(stepLog.getScreenshotAfter());
        return List.of(beforeScreenshot, afterScreenshot);
    }

    public static Status mapQtafScenarioStatusToAllureTestResultStatus(TestScenarioLogCollection.Status status) {
        if (status == TestScenarioLogCollection.Status.SUCCESS) {
            return Status.PASSED;
        }
        if (status == TestScenarioLogCollection.Status.SKIPPED) {
            return Status.SKIPPED;
        }
        if (status == TestScenarioLogCollection.Status.FAILURE) {
            return Status.FAILED;
        }
        return Status.BROKEN;
    }
}

