/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.allure;

import com.google.gson.Gson;
import de.qytera.qtaf.allure.AllureTestResultGenerator;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import io.qameta.allure.model.TestResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;

public class AllureReportGenerator {
    public static void generateReport(TestSuiteLogCollection suite) throws IOException {
        List<TestResult> testResults = AllureTestResultGenerator.fromQtafTestSuiteCollection(suite);
        String path = DirectoryHelper.preparePath((String)"$USER_DIR/allure-results");
        DirectoryHelper.createDirectoryIfNotExists((String)path);
        for (TestResult testResult : testResults) {
            AllureReportGenerator.generateReportFile(suite, testResult, path);
        }
    }

    public static void generateReportFile(TestSuiteLogCollection suite, TestResult testResult, String path) {
        Gson gson = GsonFactory.getInstance();
        String json = gson.toJson((Object)testResult);
        String reportPath = DirectoryHelper.preparePath((String)Paths.get(path, testResult.getTestCaseId().replace(' ', '-').replace('.', '-').replace('_', '-').replace("'", "").toLowerCase() + suite.getStart().getTime() + "-result.json").toString());
        try {
            DirectoryHelper.createDirectoryIfNotExists((String)suite.getLogDirectory());
            Files.write(Paths.get(reportPath, new String[0]), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    private AllureReportGenerator() {
    }
}

