/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.data.csv;

import de.qytera.qtaf.core.io.DirectoryHelper;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class CsvLoader {
    protected String filePath = "";
    protected boolean hasHeaders = true;
    protected String[] HEADERS = new String[0];

    protected String getFilePath() {
        return DirectoryHelper.preparePath((String)this.filePath);
    }

    public CsvLoader setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    protected boolean hasHeaders() {
        return this.hasHeaders;
    }

    protected char getDelimiter() {
        return ',';
    }

    protected String[] getHeaders() {
        return this.HEADERS;
    }

    protected Reader getReader() throws FileNotFoundException {
        return new FileReader(this.getFilePath());
    }

    public Iterable<CSVRecord> getCsvRecords() throws IOException {
        Reader in = this.getReader();
        CSVFormat csv = CSVFormat.DEFAULT;
        csv = csv.withDelimiter(this.getDelimiter()).withIgnoreSurroundingSpaces().withIgnoreEmptyLines();
        if (this.hasHeaders()) {
            csv = csv.withHeader(this.getHeaders()).withFirstRecordAsHeader();
        }
        return csv.parse(in);
    }
}

