/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.htmlreport.creator;

import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.htmlreport.creator.IReportCreator;
import de.qytera.qtaf.htmlreport.engine.TemplateEngine;
import de.qytera.qtaf.htmlreport.events.QtafHtmlReportEvents;
import io.pebbletemplates.pebble.error.LoaderException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class ReportCreator
implements IReportCreator {
    protected String rootTemplate = "de/qytera/qtaf/htmlreport/templates/home.html";
    protected String filename = "Report.html";

    @Override
    public boolean createReport(TestSuiteLogCollection logCollection) {
        Writer writer = this.getRenderedTemplate(logCollection);
        if (writer == null) {
            return false;
        }
        String reportPath = this.persistRenderedTemplate(logCollection, writer);
        if (reportPath == null) {
            return false;
        }
        QtafHtmlReportEvents.htmlReportCreated.onNext((Object)reportPath);
        return true;
    }

    public Writer getRenderedTemplate(TestSuiteLogCollection logCollection) {
        StringWriter writer;
        PebbleTemplate compiledTemplate = this.getPebbleTemplate();
        if (compiledTemplate == null) {
            return null;
        }
        Map<String, Object> context = this.getTemplateContext(logCollection);
        if (this.renderTemplate(compiledTemplate, context, writer = new StringWriter())) {
            return null;
        }
        return writer;
    }

    protected String persistRenderedTemplate(TestSuiteLogCollection logCollection, Writer writer) {
        String reportPath = this.getReportPath(logCollection);
        try {
            Path filepath = Paths.get(reportPath, new String[0]);
            Files.createDirectories(filepath.getParent(), new FileAttribute[0]);
            Files.write(filepath, writer.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            QtafHtmlReportEvents.htmlReportCreated.onError((Throwable)e);
            return null;
        }
        return reportPath;
    }

    public boolean renderTemplate(PebbleTemplate compiledTemplate, Map<String, Object> context, Writer writer) {
        try {
            compiledTemplate.evaluate(writer, context);
        }
        catch (IOException e) {
            e.printStackTrace();
            QtafHtmlReportEvents.htmlReportCreated.onError((Throwable)e);
            return true;
        }
        return false;
    }

    protected Map<String, Object> getTemplateContext(TestSuiteLogCollection logCollection) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("testSuiteLog", logCollection);
        context.put("testFeatureLogCollections", logCollection.getTestFeatureLogCollections());
        return context;
    }

    protected PebbleTemplate getPebbleTemplate() {
        PebbleTemplate compiledTemplate;
        try {
            compiledTemplate = TemplateEngine.getTemplate(this.getRootTemplate());
        }
        catch (LoaderException e) {
            e.printStackTrace();
            QtafHtmlReportEvents.htmlReportCreated.onError((Throwable)e);
            return null;
        }
        return compiledTemplate;
    }

    protected String getRootTemplate() {
        return this.rootTemplate;
    }

    public String getReportPath(TestSuiteLogCollection logCollection) {
        return DirectoryHelper.preparePath((String)(logCollection.getLogDirectory() + "/" + this.filename));
    }
}

