/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.http;

import com.google.gson.JsonElement;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.events.HTTPEvents;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.glassfish.jersey.gson.internal.JsonGsonProvider;

public final class WebService {
    private static final Client CLIENT = (Client)ClientBuilder.newClient().register(JsonGsonProvider.class);
    private static final int MAX_RETRIES = 3;

    private static Response wrapInRetry(Invocation request, URI path) {
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                QtafFactory.getLogger().info(String.format("[QTAF HTTP] Sending request to %s...", path), new Object[0]);
            }
            try {
                return request.invoke();
            }
            catch (ProcessingException exception) {
                if (i < 2) {
                    QtafFactory.getLogger().warn(String.format("[QTAF HTTP] Request %s failed, sending attempt %d/%d... (reason: %s)", new Object[]{path, i + 2, 3, exception}), new Object[0]);
                    continue;
                }
                QtafFactory.getLogger().error(String.format("[QTAF HTTP] Request %s failed.", request), new Object[0]);
                continue;
            }
        }
        return null;
    }

    public static RequestBuilder buildRequest(URI uri) {
        WebTarget target = CLIENT.target(uri);
        HTTPEvents.webResourceAvailable.onNext((Object)target);
        return new RequestBuilder(uri, target.request());
    }

    public static Response get(RequestBuilder request) {
        return WebService.wrapInRetry(request.getBuilder().buildGet(), request.getPath());
    }

    public static Response post(RequestBuilder request, JsonElement body) {
        return WebService.wrapInRetry(request.getBuilder().buildPost(Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE)), request.getPath());
    }

    public static Response put(RequestBuilder request, JsonElement body) {
        return WebService.wrapInRetry(request.getBuilder().buildPut(Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE)), request.getPath());
    }

    public static Response delete(RequestBuilder request) {
        return WebService.wrapInRetry(request.getBuilder().buildDelete(), request.getPath());
    }

    private WebService() {
    }
}

