/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.core.net.http;

import de.qytera.qtaf.core.gson.GsonHelper;
import de.qytera.qtaf.core.net.http.HTTPDao;

public class HTTPJsonDao
extends HTTPDao {
    public HTTPJsonDao(String host) {
        super(host);
    }

    public <T> T get(String path, Class<T> tClass) {
        String json = super.getAsString(path, "application/json");
        return (T)GsonHelper.fromJson((String)json, tClass);
    }

    public <T> T post(String path, Class<T> tClass, Object requestEntity) {
        String json = super.postAsString(path, "application/json", this.gson.toJson(requestEntity));
        return (T)GsonHelper.fromJson((String)json, tClass);
    }

    public <T> T put(String path, Class<T> tClass, Object requestEntity) {
        String json = super.putAsString(path, "application/json", this.gson.toJson(requestEntity));
        return (T)GsonHelper.fromJson((String)json, tClass);
    }

    public <T> T delete(String path, Class<T> tClass) {
        String json = super.deleteAsString(path, "application/json");
        return (T)GsonHelper.fromJson((String)json, tClass);
    }
}

