// Generated by delombok at Wed May 15 15:24:27 UTC 2024
package de.qytera.qtaf.apitesting.log.model.message;

import de.qytera.qtaf.core.log.model.LogLevel;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import io.restassured.http.*;
import io.restassured.response.ExtractableResponse;
import io.restassured.specification.QueryableRequestSpecification;
import java.util.*;

/**
 * This class provides the data format for Api log messages, which QTAF uses for reporting and logging.
 * This format is visible to users and is also used in other QTAF modules,
 * e.g. when creating JSON or HTML reports or in plugins.
 */
public class ApiLogMessage extends LogMessage {
    /**
     * Request object.
     */
    Request request = new Request();
    /**
     * Response object.
     */
    Response response = new Response();

    /**
     * Constructor.
     *
     * @param level   log level
     * @param message log message
     */
    public ApiLogMessage(LogLevel level, String message) {
        super(level, message);
    }


    /**
     * One part of the API log message is the request.
     * It's data format is defined in this class
     */
    public static class Request {
        private String requestMethod;
        private String baseUri;
        private String basePath;
        private Map<String, String> pathParams;
        private Map<String, String> queryParams;
        private Map<String, String> formParams;
        private String bodyAsString;
        private String contentType;
        private Headers headers;

        /**
         * Set the corresponding values in the Request-Api-LogMessage.
         * Depending on the response of the API request from RESTAssured.
         *
         * @param request queryable request specification of RESTassured
         */
        public void setRequestAttributes(QueryableRequestSpecification request) {
            requestMethod = request.getMethod();
            baseUri = (!Objects.equals(request.getBaseUri(), "")) ? request.getBaseUri() : null;
            basePath = (!Objects.equals(request.getBasePath(), "")) ? request.getBasePath() : null;
            pathParams = !request.getPathParams().isEmpty() ? request.getPathParams() : null;
            queryParams = !request.getQueryParams().isEmpty() ? request.getQueryParams() : null;
            headers = request.getHeaders();
            contentType = request.getContentType();
            formParams = request.getFormParams();
            bodyAsString = (request.getBody() != null) ? request.getBody().toString() : null;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Request() {
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setRequestMethod(final String requestMethod) {
            this.requestMethod = requestMethod;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBaseUri(final String baseUri) {
            this.baseUri = baseUri;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBasePath(final String basePath) {
            this.basePath = basePath;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setPathParams(final Map<String, String> pathParams) {
            this.pathParams = pathParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setQueryParams(final Map<String, String> queryParams) {
            this.queryParams = queryParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setFormParams(final Map<String, String> formParams) {
            this.formParams = formParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBodyAsString(final String bodyAsString) {
            this.bodyAsString = bodyAsString;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setContentType(final String contentType) {
            this.contentType = contentType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setHeaders(final Headers headers) {
            this.headers = headers;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ApiLogMessage.Request)) return false;
            final ApiLogMessage.Request other = (ApiLogMessage.Request) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$requestMethod = this.getRequestMethod();
            final java.lang.Object other$requestMethod = other.getRequestMethod();
            if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) return false;
            final java.lang.Object this$baseUri = this.getBaseUri();
            final java.lang.Object other$baseUri = other.getBaseUri();
            if (this$baseUri == null ? other$baseUri != null : !this$baseUri.equals(other$baseUri)) return false;
            final java.lang.Object this$basePath = this.getBasePath();
            final java.lang.Object other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) return false;
            final java.lang.Object this$pathParams = this.getPathParams();
            final java.lang.Object other$pathParams = other.getPathParams();
            if (this$pathParams == null ? other$pathParams != null : !this$pathParams.equals(other$pathParams)) return false;
            final java.lang.Object this$queryParams = this.getQueryParams();
            final java.lang.Object other$queryParams = other.getQueryParams();
            if (this$queryParams == null ? other$queryParams != null : !this$queryParams.equals(other$queryParams)) return false;
            final java.lang.Object this$formParams = this.getFormParams();
            final java.lang.Object other$formParams = other.getFormParams();
            if (this$formParams == null ? other$formParams != null : !this$formParams.equals(other$formParams)) return false;
            final java.lang.Object this$bodyAsString = this.getBodyAsString();
            final java.lang.Object other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) return false;
            final java.lang.Object this$contentType = this.getContentType();
            final java.lang.Object other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) return false;
            final java.lang.Object this$headers = this.getHeaders();
            final java.lang.Object other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ApiLogMessage.Request;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $requestMethod = this.getRequestMethod();
            result = result * PRIME + ($requestMethod == null ? 43 : $requestMethod.hashCode());
            final java.lang.Object $baseUri = this.getBaseUri();
            result = result * PRIME + ($baseUri == null ? 43 : $baseUri.hashCode());
            final java.lang.Object $basePath = this.getBasePath();
            result = result * PRIME + ($basePath == null ? 43 : $basePath.hashCode());
            final java.lang.Object $pathParams = this.getPathParams();
            result = result * PRIME + ($pathParams == null ? 43 : $pathParams.hashCode());
            final java.lang.Object $queryParams = this.getQueryParams();
            result = result * PRIME + ($queryParams == null ? 43 : $queryParams.hashCode());
            final java.lang.Object $formParams = this.getFormParams();
            result = result * PRIME + ($formParams == null ? 43 : $formParams.hashCode());
            final java.lang.Object $bodyAsString = this.getBodyAsString();
            result = result * PRIME + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            final java.lang.Object $contentType = this.getContentType();
            result = result * PRIME + ($contentType == null ? 43 : $contentType.hashCode());
            final java.lang.Object $headers = this.getHeaders();
            result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ApiLogMessage.Request(requestMethod=" + this.getRequestMethod() + ", baseUri=" + this.getBaseUri() + ", basePath=" + this.getBasePath() + ", pathParams=" + this.getPathParams() + ", queryParams=" + this.getQueryParams() + ", formParams=" + this.getFormParams() + ", bodyAsString=" + this.getBodyAsString() + ", contentType=" + this.getContentType() + ", headers=" + this.getHeaders() + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRequestMethod() {
            return this.requestMethod;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBaseUri() {
            return this.baseUri;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBasePath() {
            return this.basePath;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, String> getPathParams() {
            return this.pathParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, String> getQueryParams() {
            return this.queryParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, String> getFormParams() {
            return this.formParams;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getContentType() {
            return this.contentType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Headers getHeaders() {
            return this.headers;
        }
    }


    /**
     * One part of the API log message is the response.
     * It's data format is defined in this class
     */
    public static class Response {
        private int statusCode;
        private Headers headers;
        private String contentType;
        private Map<String, String> cookies;
        private String bodyAsString;
        private long time;

        /**
         * Set the corresponding values in the Response-Api-LogMessage,
         * depending on the request the API call is based on provided by RESTAssured.
         *
         * @param response extractable response of RESTassured
         */
        public void setResponseAttributes(ExtractableResponse<io.restassured.response.Response> response) {
            statusCode = response.statusCode();
            headers = response.headers();
            cookies = response.cookies();
            contentType = response.contentType();
            time = response.time();
            bodyAsString = response.body().asString();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Response() {
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setStatusCode(final int statusCode) {
            this.statusCode = statusCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setHeaders(final Headers headers) {
            this.headers = headers;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setContentType(final String contentType) {
            this.contentType = contentType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setCookies(final Map<String, String> cookies) {
            this.cookies = cookies;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setBodyAsString(final String bodyAsString) {
            this.bodyAsString = bodyAsString;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setTime(final long time) {
            this.time = time;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ApiLogMessage.Response)) return false;
            final ApiLogMessage.Response other = (ApiLogMessage.Response) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (this.getStatusCode() != other.getStatusCode()) return false;
            if (this.getTime() != other.getTime()) return false;
            final java.lang.Object this$headers = this.getHeaders();
            final java.lang.Object other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
            final java.lang.Object this$contentType = this.getContentType();
            final java.lang.Object other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) return false;
            final java.lang.Object this$cookies = this.getCookies();
            final java.lang.Object other$cookies = other.getCookies();
            if (this$cookies == null ? other$cookies != null : !this$cookies.equals(other$cookies)) return false;
            final java.lang.Object this$bodyAsString = this.getBodyAsString();
            final java.lang.Object other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ApiLogMessage.Response;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getStatusCode();
            final long $time = this.getTime();
            result = result * PRIME + (int) ($time >>> 32 ^ $time);
            final java.lang.Object $headers = this.getHeaders();
            result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
            final java.lang.Object $contentType = this.getContentType();
            result = result * PRIME + ($contentType == null ? 43 : $contentType.hashCode());
            final java.lang.Object $cookies = this.getCookies();
            result = result * PRIME + ($cookies == null ? 43 : $cookies.hashCode());
            final java.lang.Object $bodyAsString = this.getBodyAsString();
            result = result * PRIME + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ApiLogMessage.Response(statusCode=" + this.getStatusCode() + ", headers=" + this.getHeaders() + ", contentType=" + this.getContentType() + ", cookies=" + this.getCookies() + ", bodyAsString=" + this.getBodyAsString() + ", time=" + this.getTime() + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Headers getHeaders() {
            return this.headers;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getContentType() {
            return this.contentType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Map<String, String> getCookies() {
            return this.cookies;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public long getTime() {
            return this.time;
        }
    }

    /**
     * Create a log message based on the attributes.
     *
     * @return Log message text
     */
    public String buildMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("REQUEST:\n\n");
        if (this.getRequest().getRequestMethod() != null) {
            sb.append("Request Method: " + this.getRequest().getRequestMethod() + "\n");
        }
        if (this.getRequest().getBaseUri() != null) {
            sb.append("Base URI: " + this.getRequest().getBaseUri() + "\n");
        }
        if (this.getRequest().getBasePath() != null) {
            sb.append("Base Path: " + this.getRequest().getBasePath() + "\n");
        }
        if (this.getRequest().getContentType() != null) {
            sb.append("Content Type: " + this.getRequest().getContentType() + "\n");
        }
        if (this.getRequest().getHeaders() != null && this.getRequest().getHeaders().size() > 0) {
            sb.append("\nHeaders: \n");
            for (Header header : this.getRequest().getHeaders()) {
                sb.append("\t" + header.getName() + " = " + header.getValue() + "\n");
            }
        }
        if (this.getRequest().getPathParams() != null && this.getRequest().getPathParams().size() > 0) {
            sb.append("\nPath Params: \n");
            for (Map.Entry<String, String> pathParam : this.getRequest().getPathParams().entrySet()) {
                sb.append("\t" + pathParam.getKey() + " = " + pathParam.getValue() + "\n");
            }
        }
        if (this.getRequest().getQueryParams() != null && this.getRequest().getQueryParams().size() > 0) {
            sb.append("\nQuery Params: \n");
            for (Map.Entry<String, String> queryParam : this.getRequest().getQueryParams().entrySet()) {
                sb.append("\t" + queryParam.getKey() + " = " + queryParam.getValue() + "\n");
            }
        }
        if (this.getRequest().getFormParams() != null && this.getRequest().getFormParams().size() > 0) {
            sb.append("\nForm Params: \n");
            for (Map.Entry<String, String> formParam : this.getRequest().getFormParams().entrySet()) {
                sb.append("\t" + formParam.getKey() + " = " + formParam.getValue() + "\n");
            }
        }
        if (this.getRequest().getBodyAsString() != null) {
            sb.append("\nBody:\n");
            sb.append(this.getRequest().getBodyAsString());
        }
        sb.append("\n\nRESPONSE\n\n");
        sb.append("Status Code: " + this.getResponse().getStatusCode() + "\n");
        sb.append("Time: " + this.getResponse().getTime() + "\n");
        if (this.getResponse().getContentType() != null) {
            sb.append("Content Type: " + this.getResponse().getContentType() + "\n");
        }
        if (this.getResponse().getHeaders() != null && this.getResponse().getHeaders().size() > 0) {
            sb.append("\nHeaders: \n");
            for (Header header : this.getResponse().getHeaders()) {
                sb.append("\t" + header.getName() + " = " + header.getValue() + "\n");
            }
        }
        if (this.getResponse().getCookies() != null && this.getResponse().getCookies().size() > 0) {
            sb.append("\nCookies: \n");
            for (Map.Entry<String, String> cookie : this.getResponse().getCookies().entrySet()) {
                sb.append("\t" + cookie.getKey() + " = " + cookie.getValue() + "\n");
            }
        }
        if (this.getResponse().getBodyAsString() != null) {
            sb.append("\nBody:\n");
            sb.append(this.getResponse().getBodyAsString());
        }
        return sb.toString();
    }

    /**
     * Request object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Request getRequest() {
        return this.request;
    }

    /**
     * Request object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRequest(final Request request) {
        this.request = request;
    }

    /**
     * Response object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Response getResponse() {
        return this.response;
    }

    /**
     * Response object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setResponse(final Response response) {
        this.response = response;
    }
}
