/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.security.aes;

import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private static final int ITERATION_COUNT = 40000;
    private static final int KEY_LENGTH = 128;
    private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";

    public static String encrypt(String plainText, String key) throws GeneralSecurityException {
        byte[] salt = String.valueOf(new SecureRandom().nextInt()).getBytes();
        return AES.encrypt(plainText, key, salt);
    }

    public static String encrypt(String plainText, String key, byte[] salt) throws GeneralSecurityException {
        SecretKeySpec aesKey = AES.createAESKey(key.toCharArray(), salt);
        Cipher pbeCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        pbeCipher.init(1, aesKey);
        AlgorithmParameters parameters = pbeCipher.getParameters();
        GCMParameterSpec gcmParameterSpec = parameters.getParameterSpec(GCMParameterSpec.class);
        byte[] cipherText = pbeCipher.doFinal(Objects.requireNonNull(plainText).getBytes(StandardCharsets.UTF_8));
        byte[] iv = gcmParameterSpec.getIV();
        return base64Encoder.encodeToString(salt) + ":" + base64Encoder.encodeToString(iv) + ":" + base64Encoder.encodeToString(cipherText);
    }

    public static String decrypt(String ciphertext, String key) throws GeneralSecurityException {
        String[] split = Objects.requireNonNull(ciphertext).split(":");
        String salt = split[0];
        String iv = split[1];
        String content = split[2];
        SecretKeySpec aesKey = AES.createAESKey(Objects.requireNonNull(key).toCharArray(), base64Decoder.decode(salt));
        Cipher pbeCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        AlgorithmParameters parameters = pbeCipher.getParameters();
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(parameters.getParameterSpec(GCMParameterSpec.class).getTLen(), base64Decoder.decode(iv));
        pbeCipher.init(2, (Key)aesKey, gcmParameterSpec);
        try {
            return new String(pbeCipher.doFinal(base64Decoder.decode(content)), StandardCharsets.UTF_8);
        }
        catch (BadPaddingException exception) {
            throw new BadPaddingException(String.format("%s Make sure you're using the correct key", exception.getMessage()));
        }
    }

    public static SecretKeySpec createAESKey(char[] passphrase, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(passphrase, salt, 40000, 128);
        SecretKey keyTmp = keyFactory.generateSecret(keySpec);
        return new SecretKeySpec(keyTmp.getEncoded(), "AES");
    }

    private AES() {
    }
}

