/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.testrail.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.testrail.entity.Attachments;
import de.qytera.testrail.utils.APIClient;
import de.qytera.testrail.utils.APIException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import lombok.Generated;

public class TestRailManager {
    public static void addResultForTestCase(APIClient client, String caseId, String runId, int status, String comment) throws APIException {
        JsonObject body = new JsonObject();
        body.add("status_id", (JsonElement)new JsonPrimitive((Number)status));
        body.add("comment", (JsonElement)new JsonPrimitive(comment));
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "add_result_for_case/" + runId + "/" + caseId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)body));){
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String content = (String)response.readEntity(String.class);
                throw new APIException(response.getStatus(), content);
            }
        }
    }

    public static void addAttachmentForTestCase(APIClient client, String testCaseId, String path) throws APIException, IOException {
        File file = new File(path);
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>();
        parts.add(EntityPart.withName((String)"attachment").fileName(file.getName()).content((InputStream)new FileInputStream(file)).build());
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "add_attachment_to_case/" + testCaseId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.entity(parts, (String)"multipart/form-data"));){
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String content = (String)response.readEntity(String.class);
                throw new APIException(response.getStatus(), content);
            }
        }
    }

    public static void deleteAttachmentForTestCase(APIClient client, String attachmentId) throws APIException {
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "delete_attachment/" + attachmentId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.post((RequestBuilder)request);){
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String content = (String)response.readEntity(String.class);
                throw new APIException(response.getStatus(), content);
            }
        }
    }

    public static Attachments getAttachmentsForTestCase(APIClient client, String testCaseId) throws APIException {
        RequestBuilder request = WebService.buildRequest((URI)URI.create(client.getUrl() + "get_attachments_for_case/" + testCaseId));
        request.getBuilder().header("Authorization", (Object)client.getAuthorizationHeader());
        try (Response response = WebService.get((RequestBuilder)request);){
            String content = (String)response.readEntity(String.class);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new APIException(response.getStatus(), content);
            }
            Attachments attachments = (Attachments)GsonFactory.getInstance().fromJson(content, Attachments.class);
            return attachments;
        }
    }

    @Generated
    private TestRailManager() {
    }
}

