/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.testrail.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.ConfigurationFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.security.aes.AES;
import de.qytera.qtaf.testrail.annotations.TestRail;
import de.qytera.qtaf.testrail.entity.Attachment;
import de.qytera.qtaf.testrail.entity.Attachments;
import de.qytera.qtaf.testrail.utils.APIClient;
import de.qytera.qtaf.testrail.utils.TestRailManager;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import lombok.Generated;
import rx.Subscription;

public class UploadTestsSubscriber
implements IEventSubscriber {
    private Subscription testFinishedSubscription;
    private static final ConfigMap CONFIG = QtafFactory.getConfiguration();
    private APIClient client = null;

    public void initialize() {
        if (this.testFinishedSubscription == null) {
            this.testFinishedSubscription = QtafEvents.logsPersisted.subscribe(this::onFinishedTesting);
        }
    }

    public APIClient setUpClient() throws GeneralSecurityException, MissingConfigurationValueException {
        if (this.client == null) {
            String url = CONFIG.getString("testrail.url");
            String clientId = CONFIG.getString("testrail.authentication.clientId");
            String clientSecret = CONFIG.getString("testrail.authentication.clientSecret");
            String key = CONFIG.getString("security.key");
            this.client = new APIClient(url);
            if (clientId == null || clientId.isBlank()) {
                throw new MissingConfigurationValueException("testrail.authentication.clientId", CONFIG);
            }
            if (clientSecret == null || clientSecret.isBlank()) {
                throw new MissingConfigurationValueException("testrail.authentication.clientSecret", CONFIG);
            }
            if (key == null || key.isBlank()) {
                this.client.setUser(clientId);
                this.client.setPassword(clientSecret);
            } else {
                this.client.setUser(AES.decrypt((String)clientId, (String)key));
                this.client.setPassword(AES.decrypt((String)clientSecret, (String)key));
            }
        }
        return this.client;
    }

    public void onFinishedTesting(String testingContext) {
        if (Boolean.FALSE.equals(CONFIG.getBoolean("testrail.enabled"))) {
            return;
        }
        try {
            this.client = this.setUpClient();
        }
        catch (MissingConfigurationValueException | GeneralSecurityException exception) {
            QtafFactory.getLogger().error("[QTAF Testrail Plugin] Failed to set up API client", new Object[]{exception});
            return;
        }
        TestSuiteLogCollection logCollection = TestSuiteLogCollection.getInstance();
        for (TestFeatureLogCollection testFeatureLogCollection : logCollection.getTestFeatureLogCollections()) {
            testFeatureLogCollection.getScenarioLogCollection().forEach(this::handleScenario);
        }
    }

    private void handleScenario(TestScenarioLogCollection scenarioLog) {
        if (scenarioLog.getStatus() == null) {
            return;
        }
        TestRail testRailIdAnnotation = (TestRail)scenarioLog.getAnnotation(TestRail.class);
        if (testRailIdAnnotation != null) {
            if (scenarioLog.getStatus().equals((Object)TestScenarioLogCollection.Status.FAILURE)) {
                this.handleScenarioFailure(scenarioLog, testRailIdAnnotation);
            } else if (scenarioLog.getStatus().equals((Object)TestScenarioLogCollection.Status.SUCCESS)) {
                this.handleScenarioSuccess(testRailIdAnnotation);
            }
        }
    }

    public void handleScenarioSuccess(TestRail testRailIdAnnotation) {
        Arrays.stream(testRailIdAnnotation.caseId()).forEach(caseId -> {
            try {
                TestRailManager.addResultForTestCase(this.client, caseId, this.getRunId(testRailIdAnnotation), 1, "");
                QtafFactory.getLogger().info("Results are uploaded to testRail", new Object[0]);
                Attachments attachments = TestRailManager.getAttachmentsForTestCase(this.client, caseId);
                if (attachments != null) {
                    for (Attachment attachment : attachments.getAttachments()) {
                        TestRailManager.deleteAttachmentForTestCase(this.client, attachment.getId());
                    }
                }
            }
            catch (Exception e) {
                QtafFactory.getLogger().error((Throwable)e, new Object[0]);
            }
        });
    }

    public void handleScenarioFailure(TestScenarioLogCollection scenarioLog, TestRail testRailIdAnnotation) {
        String errorMessage = scenarioLog.getLogMessages(StepInformationLogMessage.class).stream().filter(d -> d.getStatus().equals((Object)StepInformationLogMessage.Status.ERROR)).map(LogMessage::getMessage).findFirst().orElseThrow(() -> new IllegalStateException("expected at least one failed step"));
        for (String caseId : testRailIdAnnotation.caseId()) {
            try {
                TestRailManager.addResultForTestCase(this.client, caseId, this.getRunId(testRailIdAnnotation), 5, "Failure found in: " + errorMessage);
                TestRailManager.addAttachmentForTestCase(this.client, caseId, QtafFactory.getTestSuiteLogCollection().getLogDirectory() + "/Report.html");
                TestRailManager.addAttachmentForTestCase(this.client, caseId, scenarioLog.getScreenshotAfter());
                QtafFactory.getLogger().info("Results are uploaded to testRail", new Object[0]);
            }
            catch (Exception e) {
                QtafFactory.getLogger().error((Throwable)e, new Object[0]);
            }
        }
    }

    public String getRunId(TestRail testRailIdAnnotation) {
        ConfigMap config = ConfigurationFactory.getInstance();
        if (null != config.getString("testrail.runId")) {
            String runId = config.getString("testrail.runId");
            return runId;
        }
        if (null == testRailIdAnnotation) {
            throw new NullPointerException("The passed testRailId annotation is null");
        }
        if (testRailIdAnnotation.runId().isEmpty()) {
            throw new IllegalArgumentException("No runId could be assigned to the test case. The runId must be set either via the configuration file (testrail.runId) or via the corresponding annotation.(@TestRail)");
        }
        String runId = testRailIdAnnotation.runId();
        return runId;
    }

    @Generated
    public UploadTestsSubscriber() {
    }

    @Generated
    public Subscription getTestFinishedSubscription() {
        return this.testFinishedSubscription;
    }

    @Generated
    public APIClient getClient() {
        return this.client;
    }

    @Generated
    public void setTestFinishedSubscription(Subscription testFinishedSubscription) {
        this.testFinishedSubscription = testFinishedSubscription;
    }

    @Generated
    public void setClient(APIClient client) {
        this.client = client;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadTestsSubscriber)) {
            return false;
        }
        UploadTestsSubscriber other = (UploadTestsSubscriber)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Subscription this$testFinishedSubscription = this.getTestFinishedSubscription();
        Subscription other$testFinishedSubscription = other.getTestFinishedSubscription();
        if (this$testFinishedSubscription == null ? other$testFinishedSubscription != null : !this$testFinishedSubscription.equals(other$testFinishedSubscription)) {
            return false;
        }
        APIClient this$client = this.getClient();
        APIClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !((Object)this$client).equals(other$client));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UploadTestsSubscriber;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Subscription $testFinishedSubscription = this.getTestFinishedSubscription();
        result = result * 59 + ($testFinishedSubscription == null ? 43 : $testFinishedSubscription.hashCode());
        APIClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UploadTestsSubscriber(testFinishedSubscription=" + this.getTestFinishedSubscription() + ", client=" + this.getClient() + ")";
    }
}

