/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import com.google.gson.JsonElement;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.xray.ImportExecutionResultsRequestDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayTestStepResponseDto;
import de.qytera.qtaf.xray.dto.response.xray.ImportExecutionResultsResponseCloudDto;
import de.qytera.qtaf.xray.dto.response.xray.ImportExecutionResultsResponseDto;
import de.qytera.qtaf.xray.dto.response.xray.ImportExecutionResultsResponseServerDto;
import de.qytera.qtaf.xray.events.XrayEvents;
import de.qytera.qtaf.xray.repository.xray.XrayEndpoint;
import de.qytera.qtaf.xray.repository.xray.XrayTestRepositoryCloud;
import de.qytera.qtaf.xray.repository.xray.XrayTestRepositoryServer;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;

public interface XrayTestRepository
extends XrayEndpoint {
    public static XrayTestRepository getInstance() {
        return XrayConfigHelper.isXrayCloudService() ? new XrayTestRepositoryCloud() : new XrayTestRepositoryServer();
    }

    private URI getURIImportExecutionResults() throws URISyntaxException {
        String endpoint = XrayConfigHelper.isXrayCloudService() ? String.format("%s/import/execution", this.getXrayURL()) : String.format("%s/rest/raven/1.0/import/execution", this.getXrayURL());
        return new URI(endpoint);
    }

    default public ImportExecutionResultsResponseDto importExecutionResults(ImportExecutionResultsRequestDto body) throws URISyntaxException, MissingConfigurationValueException {
        RequestBuilder request = WebService.buildRequest((URI)this.getURIImportExecutionResults());
        request.getBuilder().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.getXrayAuthorizationHeaderValue());
        try (Response response = WebService.post((RequestBuilder)request, (JsonElement)GsonFactory.getInstance().toJsonTree((Object)body));){
            ImportExecutionResultsResponseDto importExecutionResultsResponseDto;
            String responseData = (String)response.readEntity(String.class);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                XrayEvents.uploadStatus.onNext((Object)true);
            } else {
                XrayEvents.uploadStatus.onNext((Object)false);
                String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to import test execution: %s", reason), new Object[0]);
            }
            XrayEvents.uploadResponseAvailable.onNext((Object)response);
            if (XrayConfigHelper.isXrayServerService()) {
                importExecutionResultsResponseDto = (ImportExecutionResultsResponseDto)GsonFactory.getInstance().fromJson(responseData, ImportExecutionResultsResponseServerDto.class);
                return importExecutionResultsResponseDto;
            }
            if (XrayConfigHelper.isXrayCloudService()) {
                importExecutionResultsResponseDto = (ImportExecutionResultsResponseDto)GsonFactory.getInstance().fromJson(responseData, ImportExecutionResultsResponseCloudDto.class);
                return importExecutionResultsResponseDto;
            }
        }
        return null;
    }

    public Map<String, XrayTestStepResponseDto[]> getTestSteps(Collection<String> var1) throws URISyntaxException, MissingConfigurationValueException;
}

