/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.service;

import com.google.gson.Gson;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.entity.XrayAuthCredentials;
import de.qytera.qtaf.xray.events.QtafXrayEvents;
import de.qytera.qtaf.xray.log.XrayAuthenticationErrorLog;
import de.qytera.qtaf.xray.service.AbstractXrayService;

public class XrayCloudService
extends AbstractXrayService {
    private final String XRAY_CLOUD_URL = "https://xray.cloud.getxray.app/api/v1";
    private final String PATH_AUTHENTICATION = "/authenticate";
    private final String PATH_IMPORT = "/import/execution";
    private XrayAuthCredentials xrayAuthCredentials;
    private static XrayCloudService instance = null;

    public static XrayCloudService getInstance() {
        if (instance == null) {
            instance = new XrayCloudService();
            instance.setAuthCredentials(new XrayAuthCredentials(XrayConfigHelper.getClientId(), XrayConfigHelper.getClientSecret()));
        }
        return instance;
    }

    @Override
    public String getXrayURL() {
        return "https://xray.cloud.getxray.app/api/v1";
    }

    @Override
    public String getImportPath() {
        return "/import/execution";
    }

    public void setAuthCredentials(XrayAuthCredentials xrayAuthCredentials) {
        this.xrayAuthCredentials = xrayAuthCredentials;
    }

    @Override
    public String authenticate() {
        if (this.jwtToken == null) {
            WebResource webResource = this.client.resource(this.getXrayURL() + "/authenticate");
            Gson gson = GsonFactory.getInstance();
            String json = gson.toJson((Object)this.xrayAuthCredentials);
            ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)json);
            QtafXrayEvents.authenticationResponseAvailable.onNext((Object)response);
            if (response.getStatus() != 200) {
                String text = (String)response.getEntity(String.class);
                QtafXrayEvents.authenticationSuccess.onNext((Object)false);
                XrayAuthenticationErrorLog authErrorLog = new XrayAuthenticationErrorLog(new Exception(text)).setErrorMessage(response.getStatusInfo().getReasonPhrase()).setStatusCode(response.getStatus());
                this.errorLogs.addErrorLog((ErrorLog)authErrorLog);
            } else {
                QtafXrayEvents.authenticationSuccess.onNext((Object)true);
            }
            this.jwtToken = (String)gson.fromJson((String)response.getEntity(String.class), String.class);
        }
        return this.jwtToken;
    }

    @Override
    public String getJwtToken() {
        return this.jwtToken;
    }
}

