/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.builder;

import com.google.inject.Singleton;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.core.util.Base64Helper;
import de.qytera.qtaf.htmlreport.creator.ScenarioReportCreator;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.XrayImportRequestDto;
import de.qytera.qtaf.xray.entity.XrayEvidenceEntity;
import de.qytera.qtaf.xray.entity.XrayTestEntity;
import de.qytera.qtaf.xray.entity.XrayTestStepEntity;
import de.qytera.qtaf.xray.error.EvidenceUploadError;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;

@Singleton
public class XrayJsonImportBuilder {
    public XrayImportRequestDto buildFromTestSuiteLogs(TestSuiteLogCollection collection) {
        XrayImportRequestDto xrayImportRequestDto = new XrayImportRequestDto();
        ScenarioReportCreator scenarioReportCreator = new ScenarioReportCreator();
        for (TestFeatureLogCollection testFeatureLogCollection : collection.getTestFeatureLogCollections()) {
            for (TestScenarioLogCollection scenarioLog : testFeatureLogCollection.getScenarioLogCollection()) {
                if (scenarioLog.getStatus() == TestScenarioLogCollection.Status.PENDING) continue;
                XrayTestEntity xrayTestEntity = new XrayTestEntity().setTestKey(scenarioLog.getScenarioName()).setStart(null).setFinish(null).setComment("");
                if (XrayConfigHelper.isScenarioReportEvidenceEnabled()) {
                    Writer renderedTemplate = scenarioReportCreator.getRenderedTemplate(collection, scenarioLog);
                    XrayEvidenceEntity xrayReportEvidence = new XrayEvidenceEntity().setFilename("scenario_" + scenarioLog.getScenarioName() + ".html").setContentType("text/html").setData(Base64Helper.encode((String)renderedTemplate.toString()));
                    xrayTestEntity.addXrayEvidenceEntity(xrayReportEvidence);
                }
                if (XrayConfigHelper.isScenarioImageEvidenceEnabled()) {
                    for (String filepath : scenarioLog.getScreenshotPaths()) {
                        try {
                            XrayEvidenceEntity xrayEvidenceEntity = new XrayEvidenceEntity().setFilename(Paths.get(filepath, new String[0]).getFileName().toString()).setContentType("image/png").setData(Base64Helper.encodeFileContent((String)filepath));
                            xrayTestEntity.addXrayEvidenceEntity(xrayEvidenceEntity);
                        }
                        catch (IOException e) {
                            EvidenceUploadError error = new EvidenceUploadError(e).setFilepath(filepath);
                            ErrorLogCollection errors = ErrorLogCollection.getInstance();
                            errors.addErrorLog((ErrorLog)error);
                        }
                    }
                }
                xrayImportRequestDto.addTest(xrayTestEntity);
                if (scenarioLog.getStatus() == TestScenarioLogCollection.Status.SUCCESS) {
                    xrayTestEntity.setStatus(XrayTestEntity.Status.PASSED);
                } else {
                    xrayTestEntity.setStatus(XrayTestEntity.Status.FAILED);
                }
                for (LogMessage logMessage : scenarioLog.getLogMessages()) {
                    if (!(logMessage instanceof StepInformationLogMessage)) continue;
                    StepInformationLogMessage stepLog = (StepInformationLogMessage)logMessage;
                    XrayTestStepEntity xrayTestStepEntity = new XrayTestStepEntity();
                    if (stepLog.getStep() != null) {
                        xrayTestStepEntity.setComment(stepLog.getStep().getName());
                    }
                    if (XrayConfigHelper.isXrayServerService()) {
                        if (stepLog.getStatus() == StepInformationLogMessage.Status.PASS) {
                            xrayTestStepEntity.setStatus(XrayTestStepEntity.Status.PASS);
                        } else if (stepLog.getStatus() == StepInformationLogMessage.Status.ERROR) {
                            xrayTestStepEntity.setStatus(XrayTestStepEntity.Status.FAIL);
                        } else if (stepLog.getStatus() == StepInformationLogMessage.Status.PENDING) {
                            xrayTestStepEntity.setStatus(XrayTestStepEntity.Status.ABORTED);
                        }
                    } else if (stepLog.getStatus() == StepInformationLogMessage.Status.PASS) {
                        xrayTestStepEntity.setStatus(XrayTestStepEntity.Status.PASSED);
                    } else if (stepLog.getStatus() == StepInformationLogMessage.Status.ERROR) {
                        xrayTestStepEntity.setStatus(XrayTestStepEntity.Status.FAILED);
                    } else if (stepLog.getStatus() == StepInformationLogMessage.Status.PENDING) {
                        xrayTestStepEntity.setStatus(XrayTestStepEntity.Status.ABORTED);
                    }
                    xrayTestEntity.addXrayStep(xrayTestStepEntity);
                }
            }
        }
        return xrayImportRequestDto;
    }
}

