/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.service;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.XrayImportRequestDto;
import de.qytera.qtaf.xray.dto.response.XrayCloudImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayServerImportResponseDto;
import de.qytera.qtaf.xray.events.QtafXrayEvents;

public abstract class AbstractXrayService {
    protected String jwtToken = null;
    protected final Client client = new Client();
    protected final ErrorLogCollection errorLogs = ErrorLogCollection.getInstance();

    public abstract String getXrayURL();

    public abstract String getImportPath();

    public abstract String authenticate();

    public String getJwtToken() {
        return this.jwtToken;
    }

    public AbstractXrayService setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public XrayImportResponseDto importExecution(XrayImportRequestDto xrayImportDTO) {
        WebResource webResource = this.client.resource(this.getXrayURL() + this.getImportPath());
        QtafXrayEvents.webResourceAvailable.onNext((Object)webResource);
        Gson gson = GsonFactory.getInstance();
        String json = gson.toJson((Object)xrayImportDTO);
        ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.type("application/json").header("Authorization", (Object)("Bearer " + this.getJwtToken()))).post(ClientResponse.class, (Object)json);
        if (response.getStatus() == 200) {
            QtafXrayEvents.uploadStatus.onNext((Object)true);
        } else {
            QtafXrayEvents.uploadStatus.onNext((Object)false);
        }
        QtafXrayEvents.uploadResponseAvailable.onNext((Object)response);
        XrayImportResponseDto responseDto = null;
        if (XrayConfigHelper.isXrayServerService()) {
            responseDto = (XrayImportResponseDto)gson.fromJson((String)response.getEntity(String.class), XrayServerImportResponseDto.class);
        } else if (XrayConfigHelper.isXrayCloudService()) {
            responseDto = (XrayImportResponseDto)gson.fromJson((String)response.getEntity(String.class), XrayCloudImportResponseDto.class);
        }
        return responseDto;
    }
}

