/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.events.payload.IQtafTestingContext;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.xray.builder.XrayJsonImportBuilder;
import de.qytera.qtaf.xray.commands.UploadImportCommand;
import de.qytera.qtaf.xray.dto.request.XrayImportRequestDto;
import de.qytera.qtaf.xray.dto.response.XrayCloudImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayServerImportResponseDto;
import de.qytera.qtaf.xray.events.QtafXrayEvents;
import rx.Subscription;

public class UploadResultsSubscriber
implements IEventSubscriber {
    private static boolean uploaded = false;
    private static final ConfigMap config = QtafFactory.getConfiguration();
    private Subscription testFinishedSubscription;
    private UploadImportCommand uploadImportCommand;
    private static final Logger logger = QtafFactory.getLogger();
    private final XrayJsonImportBuilder xrayJsonImportBuilder = new XrayJsonImportBuilder();

    public void initialize() {
        if (this.testFinishedSubscription != null) {
            return;
        }
        if (this.uploadImportCommand == null) {
            this.uploadImportCommand = new UploadImportCommand();
        }
        this.testFinishedSubscription = QtafEvents.finishedTesting.subscribe(this::onTestFinished);
    }

    public void onTestFinished(IQtafTestingContext testContext) {
        if (!config.getBoolean("xray.enabled").booleanValue()) {
            return;
        }
        if (uploaded) {
            return;
        }
        logger.info("[QTAF Xray Plugin] Uploading Xray results ...", new Object[0]);
        XrayImportRequestDto xrayImportRequestDto = this.xrayJsonImportBuilder.buildFromTestSuiteLogs(QtafFactory.getTestSuiteLogCollection());
        QtafXrayEvents.importDtoCreated.onNext((Object)xrayImportRequestDto);
        try {
            this.uploadImportCommand.setXrayImportRequestDto(xrayImportRequestDto).execute();
        }
        catch (Exception e) {
            logger.error((Throwable)e, new Object[0]);
        }
        uploaded = true;
        XrayImportResponseDto responseDto = this.uploadImportCommand.getXrayImportResponseDto();
        if (responseDto instanceof XrayCloudImportResponseDto) {
            logger.info("[QTAF Xray Plugin] Uploaded test execution. Key is " + ((XrayCloudImportResponseDto)responseDto).getKey(), new Object[0]);
        } else if (responseDto instanceof XrayServerImportResponseDto) {
            logger.info("[QTAF Xray Plugin] Uploaded test execution. Key is " + ((XrayServerImportResponseDto)responseDto).getTestExecIssue().getKey(), new Object[0]);
        }
        QtafXrayEvents.responseDtoAvailable.onNext((Object)responseDto);
        QtafXrayEvents.responseDtoAvailable.onCompleted();
    }

    public void unsubscribe() {
        this.testFinishedSubscription.unsubscribe();
    }
}

