/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.builder;

import com.google.inject.Singleton;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.log.model.message.LogMessage;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.core.util.Base64Helper;
import de.qytera.qtaf.htmlreport.creator.ScenarioReportCreator;
import de.qytera.qtaf.xray.annotation.XrayTest;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.XrayImportRequestDto;
import de.qytera.qtaf.xray.entity.XrayEvidenceItemEntity;
import de.qytera.qtaf.xray.entity.XrayManualTestStepResultEntity;
import de.qytera.qtaf.xray.entity.XrayTestEntity;
import de.qytera.qtaf.xray.entity.XrayTestIterationParameterEntity;
import de.qytera.qtaf.xray.entity.XrayTestIterationResultEntity;
import de.qytera.qtaf.xray.error.EvidenceUploadError;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

@Singleton
public abstract class AbstractXrayJsonImportBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized XrayImportRequestDto buildFromTestSuiteLogs(TestSuiteLogCollection collection) {
        XrayImportRequestDto xrayImportRequestDto = new XrayImportRequestDto();
        ScenarioReportCreator scenarioReportCreator = new ScenarioReportCreator();
        for (TestFeatureLogCollection testFeatureLogCollection : collection.getTestFeatureLogCollections()) {
            Map groupedScenarioLogs = testFeatureLogCollection.getScenariosGroupedByAbstractScenarioId();
            for (Map.Entry entry : groupedScenarioLogs.entrySet()) {
                if (((List)entry.getValue()).size() == 1) {
                    TestScenarioLogCollection scenarioLog = (TestScenarioLogCollection)((List)entry.getValue()).get(0);
                    XrayTestEntity xrayTestEntity = this.buildTestEntityForSingleIteration(collection, xrayImportRequestDto, scenarioReportCreator, scenarioLog);
                    if (xrayTestEntity == null) continue;
                    xrayTestEntity.setIterations(null);
                    xrayImportRequestDto.addTest(xrayTestEntity);
                    continue;
                }
                if (((List)entry.getValue()).size() <= 1) continue;
                XrayTestEntity xrayTestEntity = new XrayTestEntity();
                xrayTestEntity.setSteps(null);
                boolean didScenarioPass = true;
                XrayTest xrayTestAnnotation = (XrayTest)((TestScenarioLogCollection)((List)entry.getValue()).get(0)).getAnnotation(XrayTest.class);
                assert (xrayTestAnnotation != null);
                xrayTestEntity.setTestKey(xrayTestAnnotation.key());
                List list = (List)entry.getValue();
                synchronized (list) {
                    for (TestScenarioLogCollection scenarioLog : (List)entry.getValue()) {
                        XrayTestIterationResultEntity iteration = new XrayTestIterationResultEntity();
                        boolean didIterationPass = true;
                        for (TestScenarioLogCollection.TestParameter testParameter : scenarioLog.getTestParameters()) {
                            XrayTestIterationParameterEntity parameterEntity = new XrayTestIterationParameterEntity();
                            parameterEntity.setName(testParameter.getName());
                            parameterEntity.setValue(testParameter.getValue().toString());
                            iteration.addParameter(parameterEntity);
                        }
                        List list2 = scenarioLog.getLogMessages();
                        synchronized (list2) {
                            for (LogMessage logMessage : scenarioLog.getLogMessages()) {
                                if (!(logMessage instanceof StepInformationLogMessage)) continue;
                                StepInformationLogMessage stepLog = (StepInformationLogMessage)logMessage;
                                XrayManualTestStepResultEntity xrayTestStepEntity = this.buildXrayManualTestStepResultEntity(stepLog);
                                if (stepLog.getResult() != null) {
                                    xrayTestStepEntity.setActualResult(stepLog.getResult().toString());
                                }
                                iteration.addStep(xrayTestStepEntity);
                                if (stepLog.getStatus() != StepInformationLogMessage.Status.ERROR) continue;
                                didIterationPass = false;
                            }
                        }
                        if (didIterationPass) {
                            iteration.setStatus(XrayTestIterationResultEntity.Status.PASSED);
                        } else {
                            iteration.setStatus(XrayTestIterationResultEntity.Status.FAILED);
                        }
                        if (scenarioLog.getStatus() == TestScenarioLogCollection.Status.FAILURE) {
                            didScenarioPass = false;
                        }
                        xrayTestEntity.addIteration(iteration);
                    }
                }
                if (didScenarioPass) {
                    xrayTestEntity.setStatus(XrayTestEntity.Status.PASSED);
                } else {
                    xrayTestEntity.setStatus(XrayTestEntity.Status.FAILED);
                }
                xrayImportRequestDto.addTest(xrayTestEntity);
            }
        }
        for (XrayTestEntity xrayTestEntity : xrayImportRequestDto.getTests()) {
            xrayTestEntity.setExamples(null);
        }
        return xrayImportRequestDto;
    }

    private XrayTestEntity buildTestEntityForSingleIteration(TestSuiteLogCollection collection, XrayImportRequestDto xrayImportRequestDto, ScenarioReportCreator scenarioReportCreator, TestScenarioLogCollection scenarioLog) {
        XrayTest xrayTestAnnotation = (XrayTest)scenarioLog.getAnnotation(XrayTest.class);
        if (scenarioLog.getStatus() == TestScenarioLogCollection.Status.PENDING) {
            return null;
        }
        if (xrayTestAnnotation == null) {
            return null;
        }
        return this.buildXrayTestEntity(collection, scenarioReportCreator, scenarioLog, xrayTestAnnotation);
    }

    private XrayTestEntity buildXrayTestEntity(TestSuiteLogCollection collection, ScenarioReportCreator scenarioReportCreator, TestScenarioLogCollection scenarioLog, XrayTest xrayTestAnnotation) {
        XrayTestEntity xrayTestEntity = this.initializeXrayTestEntity(scenarioLog);
        if (xrayTestAnnotation.scenarioReport()) {
            this.addScenarioReport(collection, scenarioReportCreator, scenarioLog, xrayTestEntity);
        }
        if (xrayTestAnnotation.screenshots()) {
            this.addScenarioImageEvidence(scenarioLog, xrayTestEntity);
        }
        this.setTestStatus(scenarioLog, xrayTestEntity);
        for (LogMessage logMessage : scenarioLog.getLogMessages()) {
            if (!(logMessage instanceof StepInformationLogMessage)) continue;
            StepInformationLogMessage stepLog = (StepInformationLogMessage)logMessage;
            XrayManualTestStepResultEntity xrayTestStepEntity = this.buildXrayManualTestStepResultEntity(stepLog);
            xrayTestEntity.addStep(xrayTestStepEntity);
        }
        return xrayTestEntity;
    }

    private XrayManualTestStepResultEntity buildXrayManualTestStepResultEntity(StepInformationLogMessage stepLog) {
        XrayManualTestStepResultEntity xrayTestStepEntity = new XrayManualTestStepResultEntity();
        if (stepLog.getStep() != null) {
            xrayTestStepEntity.setComment(stepLog.getStep().getName());
        }
        this.setStepStatus(stepLog, xrayTestStepEntity);
        return xrayTestStepEntity;
    }

    protected void addScenarioReport(TestSuiteLogCollection collection, ScenarioReportCreator scenarioReportCreator, TestScenarioLogCollection scenarioLog, XrayTestEntity xrayTestEntity) {
        if (XrayConfigHelper.isScenarioReportEvidenceEnabled()) {
            Writer renderedTemplate = scenarioReportCreator.getRenderedTemplate(collection, scenarioLog);
            XrayEvidenceItemEntity xrayReportEvidence = new XrayEvidenceItemEntity().setFilename("scenario_" + scenarioLog.getScenarioName() + ".html").setContentType("text/html").setData(Base64Helper.encode((String)renderedTemplate.toString()));
            xrayTestEntity.addEvidence(xrayReportEvidence);
        }
    }

    protected XrayTestEntity initializeXrayTestEntity(TestScenarioLogCollection scenarioLog) {
        Annotation[] annotations = scenarioLog.getAnnotations();
        XrayTest xrayTestAnnotation = (XrayTest)scenarioLog.getAnnotation(XrayTest.class);
        String xrayTestKey = xrayTestAnnotation != null ? xrayTestAnnotation.key() : scenarioLog.getScenarioName();
        return new XrayTestEntity().setTestKey(xrayTestKey).setStart(null).setFinish(null).setComment(scenarioLog.getDescription());
    }

    protected void addScenarioImageEvidence(TestScenarioLogCollection scenarioLog, XrayTestEntity xrayTestEntity) {
        if (XrayConfigHelper.isScenarioImageEvidenceEnabled()) {
            for (String filepath : scenarioLog.getScreenshotPaths()) {
                try {
                    XrayEvidenceItemEntity xrayEvidenceEntity = new XrayEvidenceItemEntity().setFilename(Paths.get(filepath, new String[0]).getFileName().toString()).setContentType("image/png").setData(Base64Helper.encodeFileContent((String)filepath));
                    xrayTestEntity.addEvidence(xrayEvidenceEntity);
                }
                catch (IOException e) {
                    EvidenceUploadError error = new EvidenceUploadError(e).setFilepath(filepath);
                    ErrorLogCollection errors = ErrorLogCollection.getInstance();
                    errors.addErrorLog((ErrorLog)error);
                }
            }
        }
    }

    public abstract void setTestStatus(TestScenarioLogCollection var1, XrayTestEntity var2);

    public abstract void setStepStatus(StepInformationLogMessage var1, XrayManualTestStepResultEntity var2);
}

