/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.config;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.entity.ConfigMap;

public class XrayConfigHelper {
    private static ConfigMap config = QtafFactory.getConfiguration();
    private static String XRAY_SERVICE_SELECTOR = "xray.service";
    private static String XRAY_SERVER_URL_SELECTOR = "xray.url";
    private static String BEARER_TOKEN_SELECTOR = "xray.authentication.bearerToken";
    private static String CLIENT_ID_SELECTOR = "xray.authentication.clientId";
    private static String CLIENT_SECRET_SELECTOR = "xray.authentication.clientSecret";
    private static String SCENARIO_REPORT_EVIDENCE = "xray.scenarioReportEvidence";
    private static String SCENARIO_IMAGE_EVIDENCE = "xray.scenarioImageEvidence";
    private static String XRAY_SERVICE_CLOUD = "cloud";
    private static String XRAY_SERVICE_SERVER = "server";

    public static String getBearerToken() {
        return config.getString(BEARER_TOKEN_SELECTOR);
    }

    public static String getClientId() {
        return config.getString(CLIENT_ID_SELECTOR);
    }

    public static String getClientSecret() {
        return config.getString(CLIENT_SECRET_SELECTOR);
    }

    public static String getServerUrl() {
        return config.getString(XRAY_SERVER_URL_SELECTOR);
    }

    public static String getXrayService() {
        String service = config.getString(XRAY_SERVICE_SELECTOR);
        if (service == null || !service.equals(XRAY_SERVICE_SERVER)) {
            return XRAY_SERVICE_CLOUD;
        }
        return service;
    }

    public static boolean isXrayServerService() {
        return XrayConfigHelper.getXrayService().equals(XRAY_SERVICE_SERVER);
    }

    public static boolean isXrayCloudService() {
        return XrayConfigHelper.getXrayService().equals(XRAY_SERVICE_CLOUD);
    }

    public static boolean isScenarioReportEvidenceEnabled() {
        return config.getBoolean(SCENARIO_REPORT_EVIDENCE);
    }

    public static boolean isScenarioImageEvidenceEnabled() {
        return config.getBoolean(SCENARIO_IMAGE_EVIDENCE);
    }
}

