/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.net.http;

import de.qytera.qtaf.core.net.http.HTTPJsonDao;
import de.qytera.qtaf.xray.commands.AuthenticationCommand;
import de.qytera.qtaf.xray.config.XrayConfigHelper;

public class XrayHTTPDaoFactory {
    private static HTTPJsonDao xrayServerHttpDao = null;
    private static HTTPJsonDao xrayClientHttpDao = null;

    public static HTTPJsonDao getInstance() {
        if (XrayConfigHelper.isXrayServerService()) {
            return xrayServerHttpDao;
        }
        return xrayClientHttpDao;
    }

    public static HTTPJsonDao getXrayServerHTTPJsonDao() {
        if (xrayServerHttpDao == null) {
            xrayServerHttpDao = new HTTPJsonDao(XrayConfigHelper.getServerUrl() + "/rest/raven/1.0");
            xrayServerHttpDao.setAuthorizationHeaderValue("Bearer " + XrayConfigHelper.getBearerToken());
        }
        return xrayServerHttpDao;
    }

    public static HTTPJsonDao getXrayCloudHTTPDao() {
        if (xrayClientHttpDao == null) {
            AuthenticationCommand authenticationCommand = new AuthenticationCommand();
            authenticationCommand.execute();
            xrayClientHttpDao = new HTTPJsonDao("https://xray.cloud.getxray.app/api/v2");
        }
        return xrayClientHttpDao;
    }
}

