/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.events.QtafEvents;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.events.payload.IQtafTestingContext;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.xray.builder.XrayJsonImportBuilder;
import de.qytera.qtaf.xray.commands.UploadImportCommand;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.XrayImportRequestDto;
import de.qytera.qtaf.xray.dto.response.XrayCloudImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayServerImportResponseDto;
import de.qytera.qtaf.xray.events.QtafXrayEvents;
import rx.Subscription;

public class UploadResultsSubscriber
implements IEventSubscriber {
    private static boolean uploaded = false;
    private Subscription testFinishedSubscription;
    private static final UploadImportCommand UPLOAD_IMPORT_COMMAND = new UploadImportCommand();
    private static final Logger logger = QtafFactory.getLogger();

    public void initialize() {
        if (this.testFinishedSubscription != null) {
            return;
        }
        this.testFinishedSubscription = QtafEvents.finishedTesting.subscribe(UploadResultsSubscriber::onTestFinished);
    }

    public static void onTestFinished(IQtafTestingContext testContext) {
        if (!Boolean.TRUE.equals(QtafFactory.getConfiguration().getBoolean("xray.enabled"))) {
            return;
        }
        if (uploaded) {
            return;
        }
        uploaded = true;
        logger.info("[QTAF Xray Plugin] Uploading Xray results ...", new Object[0]);
        if (XrayConfigHelper.getProjectKey() == null) {
            throw new MissingConfigurationValueException("xray.projectKey", QtafFactory.getConfiguration());
        }
        try {
            XrayImportRequestDto xrayImportRequestDto = new XrayJsonImportBuilder(QtafFactory.getTestSuiteLogCollection()).buildRequest();
            QtafXrayEvents.importDtoCreated.onNext((Object)xrayImportRequestDto);
            UPLOAD_IMPORT_COMMAND.setXrayImportRequestDto(xrayImportRequestDto).execute();
            XrayImportResponseDto responseDto = UPLOAD_IMPORT_COMMAND.getXrayImportResponseDto();
            String key = null;
            if (responseDto instanceof XrayCloudImportResponseDto) {
                XrayCloudImportResponseDto xrayCloudImportResponseDto = (XrayCloudImportResponseDto)responseDto;
                key = xrayCloudImportResponseDto.getKey();
            } else if (responseDto instanceof XrayServerImportResponseDto) {
                XrayServerImportResponseDto xrayServerImportResponseDto = (XrayServerImportResponseDto)responseDto;
                key = xrayServerImportResponseDto.getTestExecIssue().getKey();
            }
            logger.info(String.format("[QTAF Xray Plugin] Uploaded test execution. Key is %s", key), new Object[0]);
            QtafXrayEvents.responseDtoAvailable.onNext((Object)responseDto);
            QtafXrayEvents.responseDtoAvailable.onCompleted();
        }
        catch (XrayJsonImportBuilder.NoXrayTestException e) {
            logger.info("[QTAF Xray Plugin] No tests linked to Xray issues were executed. Skipping upload.", new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e, new Object[0]);
        }
    }
}

