/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.service;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.XrayImportRequestDto;
import de.qytera.qtaf.xray.dto.request.issues.AdditionalField;
import de.qytera.qtaf.xray.dto.request.issues.JiraIssueSearchRequestDto;
import de.qytera.qtaf.xray.dto.response.XrayCloudImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayImportResponseDto;
import de.qytera.qtaf.xray.dto.response.XrayServerImportResponseDto;
import de.qytera.qtaf.xray.dto.response.issues.JiraIssueResponseDto;
import de.qytera.qtaf.xray.dto.response.issues.JiraIssueSearchResponseDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayTestStepResponseDto;
import de.qytera.qtaf.xray.events.QtafXrayEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public abstract class AbstractXrayService {
    protected String jwtToken = null;
    protected final Client client = new Client();
    protected final Logger logger = QtafFactory.getLogger();
    protected final ErrorLogCollection errorLogs = ErrorLogCollection.getInstance();

    public abstract String getXrayURL();

    public abstract String getImportPath();

    public abstract String getIssueSearchPath();

    public abstract String authorizationHeaderXray();

    public abstract String authorizationHeaderJira();

    public String getJwtToken() {
        return this.jwtToken;
    }

    public AbstractXrayService setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public XrayImportResponseDto importExecution(XrayImportRequestDto xrayImportDTO) {
        WebResource webResource = this.client.resource(this.getXrayURL() + this.getImportPath());
        QtafXrayEvents.webResourceAvailable.onNext((Object)webResource);
        Gson gson = GsonFactory.getInstance();
        String json = gson.toJson((Object)xrayImportDTO);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.type("application/json").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).header("Authorization", (Object)("Bearer " + this.getJwtToken()))).post(ClientResponse.class, (Object)json);
        String responseJson = (String)response.getEntity(String.class);
        if (response.getStatus() == ClientResponse.Status.OK.getStatusCode()) {
            QtafXrayEvents.uploadStatus.onNext((Object)true);
        } else {
            String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseJson);
            this.logger.error(String.format("Failed to import test execution: %s", reason), new Object[0]);
            QtafXrayEvents.uploadStatus.onNext((Object)false);
        }
        QtafXrayEvents.uploadResponseAvailable.onNext((Object)response);
        XrayImportResponseDto responseDto = null;
        if (XrayConfigHelper.isXrayServerService()) {
            responseDto = (XrayImportResponseDto)gson.fromJson(responseJson, XrayServerImportResponseDto.class);
        } else if (XrayConfigHelper.isXrayCloudService()) {
            responseDto = (XrayImportResponseDto)gson.fromJson(responseJson, XrayCloudImportResponseDto.class);
        }
        return responseDto;
    }

    public List<JiraIssueResponseDto> searchJiraIssues(Collection<String> testIssueKeys, AdditionalField ... fields) {
        ArrayList<JiraIssueResponseDto> issues = new ArrayList<JiraIssueResponseDto>();
        JiraIssueSearchRequestDto dto = new JiraIssueSearchRequestDto();
        String jql = String.format("issue in (%s)", String.join((CharSequence)",", testIssueKeys));
        dto.setJql(jql);
        dto.setFields((String[])Arrays.stream(fields).map(AdditionalField::getText).toArray(String[]::new));
        int total = Integer.MAX_VALUE;
        int startAt = 0;
        while (issues.size() != total) {
            dto.setStartAt(startAt);
            WebResource webResource = this.client.resource(XrayConfigHelper.getJiraUrl() + this.getIssueSearchPath());
            QtafXrayEvents.webResourceAvailable.onNext((Object)webResource);
            String json = GsonFactory.getInstance().toJson((Object)dto);
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).header("Authorization", (Object)this.authorizationHeaderJira())).post(ClientResponse.class, (Object)json);
            String responseJson = (String)response.getEntity(String.class);
            JiraIssueSearchResponseDto paginatedResult = (JiraIssueSearchResponseDto)GsonFactory.getInstance().fromJson(responseJson, JiraIssueSearchResponseDto.class);
            if (response.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseJson);
                String message = String.format("Failed to search for Jira issues using search body '%s': %s", json, reason);
                this.logger.error(message, new Object[0]);
                break;
            }
            total = paginatedResult.getTotal();
            issues.addAll(Arrays.asList(paginatedResult.getIssues()));
            startAt = issues.size();
        }
        return issues;
    }

    protected Map<String, String> getIssueIds(Collection<String> testIssueKeys) {
        HashMap<String, String> issueIds = new HashMap<String, String>();
        List<JiraIssueResponseDto> issues = this.searchJiraIssues(testIssueKeys, AdditionalField.ISSUE_KEY, AdditionalField.ID);
        issues.forEach(issue -> issueIds.put(issue.getKey(), issue.getId()));
        return issueIds;
    }

    public abstract Map<String, XrayTestStepResponseDto[]> getTestSteps(Collection<String> var1);
}

