/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.service;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.response.steps.XrayServerTestStepResponseDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayTestStepResponseDto;
import de.qytera.qtaf.xray.events.QtafXrayEvents;
import de.qytera.qtaf.xray.service.AbstractXrayService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class XrayServerService
extends AbstractXrayService {
    private static final XrayServerService INSTANCE = new XrayServerService();

    public static XrayServerService getInstance() {
        return INSTANCE;
    }

    private XrayServerService() {
    }

    @Override
    public String getXrayURL() {
        return XrayConfigHelper.getServerUrl();
    }

    @Override
    public String getImportPath() {
        return "/rest/raven/1.0/import/execution";
    }

    @Override
    public String getIssueSearchPath() {
        return "/rest/api/2/search";
    }

    @Override
    public String authorizationHeaderXray() {
        String bearerToken = XrayConfigHelper.getAuthenticationXrayBearerToken();
        if (bearerToken == null) {
            throw new MissingConfigurationValueException("xray.authentication.xray.bearerToken", QtafFactory.getConfiguration());
        }
        return String.format("Bearer %s", bearerToken);
    }

    @Override
    public String authorizationHeaderJira() {
        String bearerToken = XrayConfigHelper.getAuthenticationJiraAPIToken();
        if (bearerToken == null) {
            throw new MissingConfigurationValueException("xray.authentication.jira.apiToken", QtafFactory.getConfiguration());
        }
        return String.format("Bearer %s", bearerToken);
    }

    private XrayServerTestStepResponseDto[] parseTestStepResponse(String testKey, ClientResponse response) {
        if (response.getStatus() == ClientResponse.Status.OK.getStatusCode()) {
            return (XrayServerTestStepResponseDto[])GsonFactory.getInstance().fromJson((String)response.getEntity(String.class), XrayServerTestStepResponseDto[].class);
        }
        String reason = String.format("%d %s", response.getStatus(), response.getStatusInfo().getReasonPhrase());
        String message = String.format("Failed to retrieve test steps for issue %s: %s", testKey, reason);
        this.logger.error(message, new Object[0]);
        this.errorLogs.addErrorLog((Throwable)new IllegalStateException(message));
        return new XrayServerTestStepResponseDto[0];
    }

    @Override
    public Map<String, XrayTestStepResponseDto[]> getTestSteps(Collection<String> testIssueKeys) {
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssue = new HashMap<String, XrayTestStepResponseDto[]>();
        Map<String, String> issueIds = this.getIssueIds(testIssueKeys);
        issueIds.forEach((testKey, issueId) -> {
            String path = String.format("%s/rest/raven/1.0/api/test/%s/step", this.getXrayURL(), testKey);
            WebResource webResource = this.client.resource(path);
            QtafXrayEvents.webResourceAvailable.onNext((Object)webResource);
            ClientResponse response = (ClientResponse)((WebResource.Builder)webResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.authorizationHeaderXray())).get(ClientResponse.class);
            XrayServerTestStepResponseDto[] steps = this.parseTestStepResponse((String)testKey, response);
            stepsByIssue.put((String)testKey, steps);
        });
        return stepsByIssue;
    }
}

