/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.builder.test;

import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.xray.annotation.XrayTest;
import de.qytera.qtaf.xray.builder.test.XrayTestEntityBuilder;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.entity.XrayCustomFieldEntity;
import de.qytera.qtaf.xray.entity.XrayEvidenceItemEntity;
import de.qytera.qtaf.xray.entity.XrayIterationResultEntity;
import de.qytera.qtaf.xray.entity.XrayManualTestStepResultEntity;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntity;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntityCloud;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntityServer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class SingleIterationXrayTestEntityBuilder
extends XrayTestEntityBuilder<TestScenarioLogCollection> {
    public SingleIterationXrayTestEntityBuilder(@NonNull TestSuiteLogCollection collection, @NonNull Map<String, String> issueSummaries) {
        super(collection, issueSummaries);
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (issueSummaries == null) {
            throw new NullPointerException("issueSummaries is marked non-null but is null");
        }
    }

    @Override
    protected TestScenarioLogCollection.Status getStatus(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return scenario.getStatus();
    }

    @Override
    protected XrayTestInfoEntity getTestInfo(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        XrayTestInfoEntity entity = null;
        if (XrayConfigHelper.shouldResultsUploadTestsInfoStepsUpdate()) {
            String projectKey = XrayConfigHelper.getProjectKey();
            entity = XrayConfigHelper.isXrayCloudService() ? new XrayTestInfoEntityCloud((String)this.issueSummaries.get(xrayTest.key()), projectKey, "Manual") : new XrayTestInfoEntityServer((String)this.issueSummaries.get(xrayTest.key()), projectKey, "Manual");
            for (StepInformationLogMessage step : scenario.getLogMessages(StepInformationLogMessage.class)) {
                entity.getSteps().add(SingleIterationXrayTestEntityBuilder.buildTestStepEntity(step));
            }
        }
        return entity;
    }

    @Override
    protected Date getStartDate(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return scenario.getStart();
    }

    @Override
    protected Date getEndDate(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return scenario.getEnd();
    }

    @Override
    protected String getComment(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return null;
    }

    @Override
    protected String getExecutedBy(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return null;
    }

    @Override
    protected String getAssignee(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return null;
    }

    @Override
    protected List<XrayManualTestStepResultEntity> getSteps(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        ArrayList<XrayManualTestStepResultEntity> steps = new ArrayList<XrayManualTestStepResultEntity>();
        for (StepInformationLogMessage step : scenario.getLogMessages(StepInformationLogMessage.class)) {
            steps.add(SingleIterationXrayTestEntityBuilder.buildManualTestStepResultEntity(step));
        }
        return steps;
    }

    @Override
    protected List<String> getExamples(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return Collections.emptyList();
    }

    @Override
    protected List<XrayIterationResultEntity> getIterations(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getDefects(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return Collections.emptyList();
    }

    @Override
    protected List<XrayEvidenceItemEntity> getEvidence(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        ArrayList<XrayEvidenceItemEntity> evidence = new ArrayList<XrayEvidenceItemEntity>();
        if (XrayConfigHelper.isScenarioReportEvidenceEnabled() && xrayTest.scenarioReport()) {
            Writer renderedTemplate = this.reportCreator.getRenderedTemplate(this.collection, scenario);
            String filename = "scenario_" + scenario.getScenarioName() + ".html";
            evidence.add(XrayEvidenceItemEntity.fromString(renderedTemplate.toString(), filename));
        }
        if (XrayConfigHelper.isScenarioImageEvidenceEnabled() && xrayTest.screenshots()) {
            for (String filepath : scenario.getScreenshotPaths()) {
                evidence.add(XrayEvidenceItemEntity.fromFile(filepath));
            }
        }
        return evidence;
    }

    @Override
    protected List<XrayCustomFieldEntity> getCustomFields(XrayTest xrayTest, TestScenarioLogCollection scenario) {
        return Collections.emptyList();
    }
}

