/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.importer;

import de.qytera.qtaf.core.io.FileHelper;
import de.qytera.qtaf.xray.dto.XrayTestDto;
import de.qytera.qtaf.xray.dto.XrayTestDtoCollection;
import de.qytera.qtaf.xray.repository.XrayServerTestRepository;
import java.io.IOException;

public class XrayImporter {
    private static XrayServerTestRepository repository = new XrayServerTestRepository();

    public static void importTestAsFeature(String testId, String featureFilePath) throws IOException {
        XrayTestDto testDto = repository.findByTestId(testId);
        XrayImporter.createFeatureFileFromSingleTest(testDto, featureFilePath);
    }

    public static void importTestSetAsFeature(String testSetId, String featureFilePath) throws IOException {
        XrayTestDtoCollection testDtoCollection = repository.findByTestSetId(testSetId);
        XrayImporter.createFeatureFileFromTestSet(testSetId, testDtoCollection, featureFilePath);
    }

    public static void createFeatureFileFromSingleTest(XrayTestDto testDto, String filePath) throws IOException {
        FileHelper.writeFile((String)filePath, (String)XrayImporter.getFeatureFileContentFromSingleTest(testDto));
    }

    public static void createFeatureFileFromTestSet(String testSetId, XrayTestDtoCollection collection, String filePath) throws IOException {
        FileHelper.writeFile((String)filePath, (String)XrayImporter.getFeatureFileContentFromTestSet(testSetId, collection, true));
    }

    public static String getFeatureFileContentFromTestSet(String testSetId, XrayTestDtoCollection testDtoCollection, boolean newDriver) {
        StringBuilder fileContent = new StringBuilder();
        for (XrayTestDto testDto : testDtoCollection) {
            fileContent.append("\n").append(XrayImporter.addScenarioDefinition(testDto.getKey(), testDto.getDefinition()));
        }
        if (newDriver) {
            fileContent.insert(0, XrayImporter.addTag("newDriver", ""));
        }
        return XrayImporter.addFeatureDefinition(testSetId, fileContent.toString());
    }

    public static String getFeatureFileContentFromSingleTest(XrayTestDto testDto) {
        return XrayImporter.addFeatureDefinition(testDto.getKey(), XrayImporter.addScenarioDefinition(testDto.getKey(), testDto.getDefinition()));
    }

    public static String addScenarioDefinition(String scenarioName, String testDefinition) {
        Object featureFileContent = String.format("Scenario: %s\n  ", scenarioName);
        featureFileContent = (String)featureFileContent + testDefinition.replaceAll("\n", "\n  ");
        return featureFileContent;
    }

    public static String addFeatureDefinition(String featureName, String testDefinition) {
        Object featureFileContent = String.format("Feature: %s\n  ", featureName);
        featureFileContent = (String)featureFileContent + testDefinition.replaceAll("\n", "\n  ");
        return featureFileContent;
    }

    public static String addTag(String key, String gherkin) {
        return String.format("@%s\n", key) + gherkin;
    }

    public static String addTag(String key, String value, String gherkin) {
        return String.format("@%s:%s\n", key, value) + gherkin;
    }

    public static String addGroupTagToFeatureDefinition(String featureName, String featureDefinition) {
        return XrayImporter.addTag("Groups", featureName, featureDefinition);
    }
}

