/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository;

import com.sun.jersey.api.client.ClientResponse;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.core.net.http.HTTPDao;
import de.qytera.qtaf.xray.repository.IXrayCucumberRepository;
import de.qytera.qtaf.xray.service.AbstractXrayService;
import de.qytera.qtaf.xray.service.XrayCloudService;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;

public class XrayCloudCucumberRepository
implements IXrayCucumberRepository {
    private static final Logger logger = QtafFactory.getLogger();
    private static final String EXPORT_TEST_AS_CUCUMBER = "/export/cucumber?keys=%s";
    private final HTTPDao httpDao = new HTTPDao("https://xray.cloud.getxray.app/api/v2");

    @Override
    public String getFeatureFileDefinition(String[] testIDs) {
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        this.authenticateAgainstXrayAPI();
        try {
            ZipInputStream zis = this.getZipInputStreamFromAPIResponse(keys);
            zis.getNextEntry();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int content = zis.read();
            while (content != -1) {
                outputStream.write(content);
                content = zis.read();
            }
            zis.closeEntry();
            zis.close();
            String content2 = outputStream.toString(StandardCharsets.UTF_8);
            outputStream.close();
            return content2;
        }
        catch (Exception e) {
            logger.error((Throwable)e, new Object[0]);
            return "";
        }
    }

    private void authenticateAgainstXrayAPI() {
        XrayCloudService service = XrayCloudService.getInstance();
        ((AbstractXrayService)service).authorizationHeaderXray();
        this.httpDao.setAuthorizationHeaderValue("Bearer " + service.getJwtToken());
    }

    private ZipInputStream getZipInputStreamFromAPIResponse(String keys) {
        ClientResponse res = this.httpDao.get(String.format(EXPORT_TEST_AS_CUCUMBER, keys), "application/zip");
        InputStream inputStream = (InputStream)res.getEntity(InputStream.class);
        return new ZipInputStream(inputStream);
    }

    public ArrayList<String> getFeatureFileDefinitions(String[] testIDs) throws IOException {
        ZipEntry ze;
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        ArrayList<String> features = new ArrayList<String>();
        this.authenticateAgainstXrayAPI();
        ZipInputStream zis = this.getZipInputStreamFromAPIResponse(keys);
        while ((ze = zis.getNextEntry()) != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int content = zis.read();
            while (content != -1) {
                outputStream.write(content);
                content = zis.read();
            }
            zis.closeEntry();
            features.add(outputStream.toString(StandardCharsets.UTF_8));
            outputStream.close();
        }
        zis.close();
        return features;
    }

    public void getAndStoreFeatureFileDefinitions(String[] testIDs, String dir) throws IOException {
        ZipEntry ze;
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        this.authenticateAgainstXrayAPI();
        ZipInputStream zis = this.getZipInputStreamFromAPIResponse(keys);
        while ((ze = zis.getNextEntry()) != null) {
            FileOutputStream outputStream = new FileOutputStream(DirectoryHelper.preparePath((String)(dir + "/" + ze.getName())));
            int content = zis.read();
            while (content != -1) {
                outputStream.write(content);
                content = zis.read();
            }
            zis.closeEntry();
            outputStream.close();
        }
        zis.close();
    }
}

