/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.service;

import com.google.gson.Gson;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.core.log.model.error.ErrorLog;
import de.qytera.qtaf.core.util.Base64Helper;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.graphql.GraphQLRequestDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayCloudTestStepResponseDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayTestStepResponseDto;
import de.qytera.qtaf.xray.entity.XrayAuthCredentials;
import de.qytera.qtaf.xray.events.QtafXrayEvents;
import de.qytera.qtaf.xray.log.XrayAuthenticationErrorLog;
import de.qytera.qtaf.xray.service.AbstractXrayService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;

public class XrayCloudService
extends AbstractXrayService {
    private static final XrayCloudService INSTANCE = new XrayCloudService();
    private static final String PATH_AUTHENTICATION = "/authenticate";
    private static final String PATH_GRAPH_QL = "/graphql";
    private static final int GRAPH_QL_QUERY_ISSUES_LIMIT = 100;
    private XrayAuthCredentials xrayAuthCredentials;

    public static XrayCloudService getInstance() {
        if (XrayCloudService.INSTANCE.xrayAuthCredentials == null) {
            String clientId = XrayConfigHelper.getAuthenticationXrayClientId();
            if (clientId == null) {
                throw new MissingConfigurationValueException("xray.authentication.xray.clientId", QtafFactory.getConfiguration());
            }
            String clientSecret = XrayConfigHelper.getAuthenticationXrayClientSecret();
            if (clientSecret == null) {
                throw new MissingConfigurationValueException("xray.authentication.xray.clientSecret", QtafFactory.getConfiguration());
            }
            INSTANCE.setAuthCredentials(new XrayAuthCredentials(clientId, clientSecret));
        }
        return INSTANCE;
    }

    private XrayCloudService() {
    }

    @Override
    public String getXrayURL() {
        return "https://xray.cloud.getxray.app/api/v2";
    }

    @Override
    public String getImportPath() {
        return "/import/execution";
    }

    @Override
    public String getIssueSearchPath() {
        return "/rest/api/3/search";
    }

    private Map<String, XrayTestStepResponseDto[]> parseTestStepResponse(String request, ClientResponse response) {
        if (response.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
            String reason = String.format("%d %s", response.getStatus(), response.getStatusInfo().getReasonPhrase());
            String message = String.format("Failed to get test steps for issues using query '%s': %s", request, reason);
            this.logger.error(message, new Object[0]);
            this.errorLogs.addErrorLog((Throwable)new IllegalStateException(message));
            return Collections.emptyMap();
        }
        XrayCloudTestStepResponseDto stepResponse = (XrayCloudTestStepResponseDto)GsonFactory.getInstance().fromJson((String)response.getEntity(String.class), XrayCloudTestStepResponseDto.class);
        if (stepResponse.hasErrors()) {
            String message = String.format("Failed to get test steps for issues using query '%s': %s", request, stepResponse.errorReason());
            this.logger.error(message, new Object[0]);
            this.errorLogs.addErrorLog((Throwable)new IllegalStateException(message));
            return Collections.emptyMap();
        }
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssue = new HashMap<String, XrayTestStepResponseDto[]>();
        Arrays.stream(((XrayCloudTestStepResponseDto.ResponseData)stepResponse.getData()).getGetTests().getResults()).forEach(r -> stepsByIssue.put(r.getIssueId(), r.getSteps()));
        return stepsByIssue;
    }

    private Map<String, XrayTestStepResponseDto[]> convertIssueIdsToIssueKeys(Map<String, XrayTestStepResponseDto[]> stepsByIssueId, Collection<String> testIssueKeys) {
        Map<String, String> issueIds = this.getIssueIds(testIssueKeys);
        Map<String, String> testKeysByIssueId = issueIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssueKey = new HashMap<String, XrayTestStepResponseDto[]>(stepsByIssueId.size());
        stepsByIssueId.forEach((id, steps) -> stepsByIssueKey.put((String)testKeysByIssueId.get(id), (XrayTestStepResponseDto[])steps));
        return stepsByIssueKey;
    }

    @Override
    public Map<String, XrayTestStepResponseDto[]> getTestSteps(Collection<String> testIssueKeys) {
        String query = "query ($jql: String!, $limit: Int!) {\n  getTests(jql: $jql, limit: $limit) {\n    total\n    limit\n    results {\n      issueId\n      testType {\n        name\n        kind\n      }\n      steps {\n        id\n        data\n        action\n        result\n      }\n    }\n  }\n}\n";
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssue = new HashMap<String, XrayTestStepResponseDto[]>();
        for (int n = 0; n < testIssueKeys.size(); n += 100) {
            List<String> subset = testIssueKeys.stream().skip(n).limit(100L).toList();
            String jql = String.format("issue in (%s)", String.join((CharSequence)",", subset));
            WebResource webResource = this.client.resource(this.getXrayURL() + PATH_GRAPH_QL);
            QtafXrayEvents.webResourceAvailable.onNext((Object)webResource);
            GraphQLRequestDto request = new GraphQLRequestDto();
            request.setQuery(query);
            request.addVariable("jql", jql);
            request.addVariable("limit", 100);
            String json = GsonFactory.getInstance().toJson((Object)request);
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).header("Authorization", (Object)this.authorizationHeaderXray())).post(ClientResponse.class, (Object)json);
            stepsByIssue.putAll(this.parseTestStepResponse(json, response));
        }
        return this.convertIssueIdsToIssueKeys(stepsByIssue, testIssueKeys);
    }

    public void setAuthCredentials(XrayAuthCredentials xrayAuthCredentials) {
        this.xrayAuthCredentials = xrayAuthCredentials;
    }

    @Override
    public String authorizationHeaderXray() {
        if (this.jwtToken == null) {
            WebResource webResource = this.client.resource(this.getXrayURL() + PATH_AUTHENTICATION);
            Gson gson = GsonFactory.getInstance();
            String json = gson.toJson((Object)this.xrayAuthCredentials);
            ClientResponse response = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)json);
            QtafXrayEvents.authenticationResponseAvailable.onNext((Object)response);
            if (response.getStatus() != 200) {
                String text = (String)response.getEntity(String.class);
                QtafXrayEvents.authenticationSuccess.onNext((Object)false);
                XrayAuthenticationErrorLog authErrorLog = new XrayAuthenticationErrorLog(new Exception(text)).setErrorMessage(response.getStatusInfo().getReasonPhrase()).setStatusCode(response.getStatus());
                this.errorLogs.addErrorLog((ErrorLog)authErrorLog);
            } else {
                this.jwtToken = (String)gson.fromJson((String)response.getEntity(String.class), String.class);
                QtafXrayEvents.authenticationSuccess.onNext((Object)true);
            }
        }
        return String.format("Bearer %s", this.jwtToken);
    }

    @Override
    public String authorizationHeaderJira() {
        String username = XrayConfigHelper.getAuthenticationJiraUsername();
        if (username == null) {
            throw new MissingConfigurationValueException("xray.authentication.jira.username", QtafFactory.getConfiguration());
        }
        String apiToken = XrayConfigHelper.getAuthenticationJiraAPIToken();
        if (apiToken == null) {
            throw new MissingConfigurationValueException("xray.authentication.jira.apiToken", QtafFactory.getConfiguration());
        }
        String encoded = Base64Helper.encode((String)String.format("%s:%s", username, apiToken));
        return String.format("Basic %s", encoded);
    }
}

