/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.jira;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.util.Base64Helper;
import de.qytera.qtaf.xray.config.XrayConfigHelper;

public interface JiraEndpoint {
    default public String getJiraAuthorizationHeaderValue() throws MissingConfigurationValueException {
        if (XrayConfigHelper.isXrayCloudService()) {
            return JiraEndpoint.getHeaderCloud();
        }
        return JiraEndpoint.getHeaderServer();
    }

    private static String getHeaderCloud() throws MissingConfigurationValueException {
        String username = XrayConfigHelper.getAuthenticationJiraUsername();
        if (username == null) {
            throw new MissingConfigurationValueException("xray.authentication.jira.username", QtafFactory.getConfiguration());
        }
        String apiToken = XrayConfigHelper.getAuthenticationJiraAPIToken();
        if (apiToken == null) {
            throw new MissingConfigurationValueException("xray.authentication.jira.apiToken", QtafFactory.getConfiguration());
        }
        String encoded = Base64Helper.encode((String)String.format("%s:%s", username, apiToken));
        return String.format("Basic %s", encoded);
    }

    private static String getHeaderServer() throws MissingConfigurationValueException {
        String bearerToken = XrayConfigHelper.getAuthenticationXrayBearerToken();
        if (bearerToken == null) {
            throw new MissingConfigurationValueException("xray.authentication.xray.bearerToken", QtafFactory.getConfiguration());
        }
        return String.format("Bearer %s", bearerToken);
    }
}

