/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.builder;

import com.google.inject.Singleton;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.xray.annotation.XrayTest;
import de.qytera.qtaf.xray.builder.XrayJsonHelper;
import de.qytera.qtaf.xray.builder.test.MultipleIterationsXrayTestEntityBuilder;
import de.qytera.qtaf.xray.builder.test.SingleIterationXrayTestEntityBuilder;
import de.qytera.qtaf.xray.builder.test.XrayTestEntityBuilder;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.issues.AdditionalField;
import de.qytera.qtaf.xray.dto.request.xray.ImportExecutionResultsRequestDto;
import de.qytera.qtaf.xray.dto.response.issues.JiraIssueResponseDto;
import de.qytera.qtaf.xray.entity.XrayTestEntity;
import de.qytera.qtaf.xray.entity.XrayTestExecutionInfoEntity;
import de.qytera.qtaf.xray.repository.jira.JiraIssueRepository;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public class XrayJsonImportBuilder {
    private final TestSuiteLogCollection collection;
    private final XrayTestEntityBuilder<TestScenarioLogCollection> singleIterationBuilder;
    private final XrayTestEntityBuilder<List<TestScenarioLogCollection>> multipleIterationsBuilder;

    public XrayJsonImportBuilder(TestSuiteLogCollection collection) throws URISyntaxException, MissingConfigurationValueException {
        this.collection = collection;
        Map<String, String> issueSummaries = XrayJsonImportBuilder.getIssueSummaries(collection);
        this.singleIterationBuilder = new SingleIterationXrayTestEntityBuilder(this.collection, issueSummaries);
        this.multipleIterationsBuilder = new MultipleIterationsXrayTestEntityBuilder(this.collection, issueSummaries);
    }

    public ImportExecutionResultsRequestDto buildRequest() throws NoXrayTestException {
        ImportExecutionResultsRequestDto xrayImportRequestDto = new ImportExecutionResultsRequestDto();
        xrayImportRequestDto.setInfo(this.buildTestExecutionInfoEntity());
        xrayImportRequestDto.setTests(this.buildTestEntities());
        if (xrayImportRequestDto.getTests().isEmpty()) {
            throw new NoXrayTestException();
        }
        return xrayImportRequestDto;
    }

    private XrayTestExecutionInfoEntity buildTestExecutionInfoEntity() {
        XrayTestExecutionInfoEntity entity = new XrayTestExecutionInfoEntity();
        if (this.collection.getStart() != null) {
            String startDate = XrayJsonHelper.isoDateString(this.collection.getStart());
            entity.setStartDate(startDate);
        }
        if (this.collection.getEnd() != null) {
            String finishDate = XrayJsonHelper.isoDateString(this.collection.getEnd());
            entity.setFinishDate(finishDate);
        }
        entity.setTestPlanKey(XrayConfigHelper.getResultsUploadTestPlanKey());
        entity.addTestEnvironment(this.collection.getOsName());
        entity.addTestEnvironment(this.collection.getDriverName());
        return entity;
    }

    private List<XrayTestEntity> buildTestEntities() {
        ArrayList<XrayTestEntity> entities = new ArrayList<XrayTestEntity>();
        for (TestFeatureLogCollection testFeatureLogCollection : this.collection.getTestFeatureLogCollections()) {
            Map groupedScenarioLogs = testFeatureLogCollection.getScenariosGroupedByAbstractScenarioId();
            for (Map.Entry entry : groupedScenarioLogs.entrySet()) {
                List scenarioLogs = (List)entry.getValue();
                XrayTest xrayTest = XrayJsonImportBuilder.getXrayAnnotation(scenarioLogs);
                if (xrayTest == null) {
                    if (!scenarioLogs.isEmpty()) continue;
                    QtafFactory.getLogger().warn(String.format("No scenario logs found for test %s", entry.getKey()), new Object[0]);
                    continue;
                }
                XrayTestEntity entity = scenarioLogs.size() == 1 ? this.singleIterationBuilder.buildTestEntity(xrayTest, (TestScenarioLogCollection)scenarioLogs.get(0)) : this.multipleIterationsBuilder.buildTestEntity(xrayTest, scenarioLogs);
                entities.add(entity);
            }
        }
        return entities;
    }

    private static XrayTest getXrayAnnotation(List<TestScenarioLogCollection> scenarioLogs) {
        XrayTest xrayTest;
        XrayTest xrayTest2 = xrayTest = scenarioLogs.isEmpty() ? null : (XrayTest)scenarioLogs.get(0).getAnnotation(XrayTest.class);
        if (xrayTest == null) {
            return null;
        }
        String projectKey = XrayConfigHelper.getProjectKey();
        if (!xrayTest.key().contains(projectKey)) {
            QtafFactory.getLogger().warn(String.format("Xray annotation of scenario '%s' contains a project key that was not configured in %s: '%s'.This scenario's results will not be uploaded.", scenarioLogs.get(0).getScenarioName(), QtafFactory.getConfiguration().getLocation(), xrayTest.key()), new Object[0]);
            return null;
        }
        String issuePattern = String.format("^%s-%s$", projectKey, "[1-9]\\d*");
        if (!xrayTest.key().matches(issuePattern)) {
            QtafFactory.getLogger().error(String.format("Found project key '%s' in Xray annotation of scenario '%s', but failed to extract issue number. This scenario's results will not be uploaded.", projectKey, scenarioLogs.get(0).getScenarioName()), new Object[0]);
            return null;
        }
        return xrayTest;
    }

    private static Map<String, String> getIssueSummaries(TestSuiteLogCollection collection) throws URISyntaxException, MissingConfigurationValueException {
        if (!XrayConfigHelper.shouldResultsUploadTestsInfoStepsUpdate()) {
            return Collections.emptyMap();
        }
        if (XrayConfigHelper.shouldResultsUploadTestsInfoKeepJiraSummary()) {
            return XrayJsonImportBuilder.getIssueSummariesFromJira(collection);
        }
        HashMap<String, String> issueSummaries = new HashMap<String, String>();
        for (TestFeatureLogCollection featureLog : collection.getTestFeatureLogCollections()) {
            for (TestScenarioLogCollection scenarioLog : featureLog.getScenarioLogCollection()) {
                XrayTest xrayTest = (XrayTest)scenarioLog.getAnnotation(XrayTest.class);
                if (xrayTest == null) continue;
                issueSummaries.put(xrayTest.key(), scenarioLog.getScenarioName());
            }
        }
        return issueSummaries;
    }

    private static Map<String, String> getIssueSummariesFromJira(TestSuiteLogCollection collection) throws URISyntaxException, MissingConfigurationValueException {
        HashMap<String, String> issueSummaries = new HashMap<String, String>();
        Set<String> testKeys = collection.getTestFeatureLogCollections().stream().map(TestFeatureLogCollection::getScenarioLogCollection).flatMap(Collection::stream).map(scenario -> (XrayTest)scenario.getAnnotation(XrayTest.class)).filter(Objects::nonNull).map(XrayTest::key).collect(Collectors.toSet());
        List<JiraIssueResponseDto> issues = JiraIssueRepository.getInstance().searchJiraIssues(testKeys, AdditionalField.SUMMARY);
        for (JiraIssueResponseDto issue : issues) {
            issueSummaries.put(issue.getKey(), issue.getFields().get(AdditionalField.SUMMARY.text).getAsString());
            testKeys.remove(issue.getKey());
        }
        if (!testKeys.isEmpty()) {
            String message = String.format("Failed to retrieve the following issue summaries from Jira: %s", testKeys);
            QtafFactory.getLogger().error(message, new Object[0]);
            ErrorLogCollection.getInstance().addErrorLog((Throwable)new IllegalStateException(message));
        }
        return issueSummaries;
    }

    public static class NoXrayTestException
    extends Exception {
        public NoXrayTestException() {
            super("Cannot build import execution request because no test linked to Xray was executed");
        }
    }
}

