/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.jira;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.request.issues.AdditionalField;
import de.qytera.qtaf.xray.dto.request.issues.JiraIssueSearchRequestDto;
import de.qytera.qtaf.xray.dto.response.issues.JiraIssueResponseDto;
import de.qytera.qtaf.xray.dto.response.issues.JiraIssueSearchResponseDto;
import de.qytera.qtaf.xray.repository.jira.JiraEndpoint;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class JiraIssueRepository
implements JiraEndpoint {
    private static final JiraIssueRepository INSTANCE = new JiraIssueRepository();

    public static JiraIssueRepository getInstance() {
        return INSTANCE;
    }

    public List<JiraIssueResponseDto> searchJiraIssues(Collection<String> testIssueKeys, AdditionalField ... fields) throws URISyntaxException, MissingConfigurationValueException {
        ArrayList<JiraIssueResponseDto> issues = new ArrayList<JiraIssueResponseDto>();
        JiraIssueSearchRequestDto dto = new JiraIssueSearchRequestDto();
        String jql = String.format("issue in (%s)", String.join((CharSequence)",", testIssueKeys));
        dto.setJql(jql);
        dto.setFields((String[])Arrays.stream(fields).map(AdditionalField::getText).toArray(String[]::new));
        int total = Integer.MAX_VALUE;
        int startAt = 0;
        while (issues.size() != total) {
            dto.setStartAt(startAt);
            RequestBuilder request = WebService.buildRequest((URI)JiraIssueRepository.getURIIssueSearchPath());
            request.getBuilder().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.getJiraAuthorizationHeaderValue());
            try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)dto));){
                String responseData = (String)response.readEntity(String.class);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                    QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to search for Jira issues using search body '%s': %s", GsonFactory.getInstance().toJsonTree((Object)dto), reason), new Object[0]);
                    break;
                }
                JiraIssueSearchResponseDto paginatedResult = (JiraIssueSearchResponseDto)GsonFactory.getInstance().fromJson(responseData, JiraIssueSearchResponseDto.class);
                total = paginatedResult.getTotal();
                issues.addAll(Arrays.asList(paginatedResult.getIssues()));
            }
            startAt = issues.size();
        }
        return issues;
    }

    private static URI getURIIssueSearchPath() throws URISyntaxException {
        if (XrayConfigHelper.isXrayCloudService()) {
            return new URI(XrayConfigHelper.getJiraUrl() + "/rest/api/3/search");
        }
        return new URI(XrayConfigHelper.getJiraUrl() + "/rest/api/2/search");
    }

    public Map<String, String> getIssueIds(Collection<String> testIssueKeys) throws URISyntaxException, MissingConfigurationValueException {
        HashMap<String, String> issueIds = new HashMap<String, String>();
        List<JiraIssueResponseDto> issues = this.searchJiraIssues(testIssueKeys, AdditionalField.ISSUE_KEY, AdditionalField.ID);
        issues.forEach(issue -> issueIds.put(issue.getKey(), issue.getId()));
        return issueIds;
    }

    @Generated
    private JiraIssueRepository() {
    }
}

