/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.repository.xray.XrayCloudAuthenticator;

public interface XrayEndpoint {
    default public String getXrayAuthorizationHeaderValue() throws MissingConfigurationValueException {
        if (XrayConfigHelper.isXrayCloudService()) {
            return XrayEndpoint.getHeaderCloud();
        }
        return XrayEndpoint.getHeaderServer();
    }

    default public String getXrayURL() {
        if (XrayConfigHelper.isXrayCloudService()) {
            return "https://xray.cloud.getxray.app/api/v2";
        }
        return XrayConfigHelper.getServerUrl();
    }

    private static String getHeaderCloud() throws MissingConfigurationValueException {
        return XrayCloudAuthenticator.getXrayAuthorizationHeaderValue();
    }

    private static String getHeaderServer() throws MissingConfigurationValueException {
        String bearerToken = XrayConfigHelper.getAuthenticationXrayBearerToken();
        if (bearerToken == null) {
            throw new MissingConfigurationValueException("xray.authentication.xray.bearerToken", QtafFactory.getConfiguration());
        }
        return String.format("Bearer %s", bearerToken);
    }
}

