/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.event_subscriber;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.events.interfaces.IEventSubscriber;
import de.qytera.qtaf.core.log.model.collection.TestFeatureLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.response.xray.ImportExecutionResultsResponseDto;
import de.qytera.qtaf.xray.events.XrayEvents;
import de.qytera.qtaf.xray.repository.jira.JiraIssueRepository;
import java.net.URISyntaxException;
import rx.Subscription;

public class TransitionImportTestExecutionIssueSubscriber
implements IEventSubscriber {
    private Subscription subscription;

    public void initialize() {
        if (this.subscription == null) {
            this.subscription = XrayEvents.responseDtoAvailable.subscribe(TransitionImportTestExecutionIssueSubscriber::onResultsImport);
        }
    }

    private static void onResultsImport(ImportExecutionResultsResponseDto response) {
        TestScenarioLogCollection.Status status = TransitionImportTestExecutionIssueSubscriber.getTestSuiteStatus(QtafFactory.getTestSuiteLogCollection());
        String jiraStatus = status == TestScenarioLogCollection.Status.SUCCESS ? XrayConfigHelper.getResultsUploadCustomStatusTestExecutionIssuePassed() : XrayConfigHelper.getResultsUploadCustomStatusTestExecutionIssueFailed();
        if (jiraStatus == null) {
            return;
        }
        try {
            if (!JiraIssueRepository.getInstance().transitionIssue(response.getKey(), jiraStatus)) {
                QtafFactory.getLogger().warn(String.format("Test execution issue %s was not transitioned to %s. Please verify your configuration.", response.getKey(), jiraStatus), new Object[0]);
            }
        }
        catch (MissingConfigurationValueException | URISyntaxException exception) {
            QtafFactory.getLogger().error(exception, new Object[0]);
        }
    }

    private static TestScenarioLogCollection.Status getTestSuiteStatus(TestSuiteLogCollection suiteLogs) {
        for (TestFeatureLogCollection featureLogs : suiteLogs.getTestFeatureLogCollections()) {
            for (TestScenarioLogCollection scenarioLogs : featureLogs.getScenarioLogCollection()) {
                if (scenarioLogs.getStatus() == TestScenarioLogCollection.Status.SUCCESS) continue;
                return TestScenarioLogCollection.Status.FAILURE;
            }
        }
        return TestScenarioLogCollection.Status.SUCCESS;
    }
}

