/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.repository.xray.XrayCucumberRepository;
import de.qytera.qtaf.xray.repository.xray.XrayEndpoint;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class XrayCucumberRepositoryServer
implements XrayCucumberRepository,
XrayEndpoint {
    @Override
    public String getFeatureFileDefinition(String[] testIDs) throws URISyntaxException, MissingConfigurationValueException {
        RequestBuilder request = WebService.buildRequest((URI)this.getURIExportFeatureFiles(testIDs));
        request.getBuilder().header("Authorization", (Object)this.getXrayAuthorizationHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        try (Response response = WebService.get((RequestBuilder)request);){
            String string = (String)response.readEntity(String.class);
            return string;
        }
    }

    private URI getURIExportFeatureFiles(String[] testIDs) throws URISyntaxException {
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        return new URI(String.format("%s/export/test?keys=%s", this.getXrayURL(), keys));
    }
}

