// Generated by delombok at Mon Apr 08 15:08:11 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

import com.google.gson.JsonObject;

/**
 * The project details of the project an item has scope in.
 */
public class ProjectDetailsDto {
    /**
     * The URLs of the project's avatars.
     */
    private JsonObject avatarUrls;
    /**
     * The ID of the project.
     */
    private String id;
    /**
     * The key of the project.
     */
    private String key;
    /**
     * The name of the project.
     */
    private String name;
    /**
     * The category the project belongs to.
     */
    private ProjectCategoryDto projectCategory;
    /**
     * The project type of the project.
     */
    private String projectTypeKey;
    private String self;
    private Boolean simplified;

    /**
     * Set the project type.
     *
     * @param projectType the project type
     */
    public void setProjectTypeKey(ProjectType projectType) {
        this.projectTypeKey = projectType.text;
    }

    /**
     * Get the project type.
     *
     * @return the project type or null if not set
     */
    public ProjectType getProjectTypeKey() {
        if (this.projectTypeKey == null) {
            return null;
        }
        return ProjectType.valueOf(this.projectTypeKey.toUpperCase());
    }


    /**
     * The project types available in Jira.
     *
     * @see <a href="https://confluence.atlassian.com/adminjiraserver/jira-applications-and-project-types-overview-938846805.html">Jira project types</a>
     */
    public enum ProjectType {
        /**
         * A software development project.
         */
        SOFTWARE("software"), 
        /**
         * A service management project.
         */
        SERVICE_DESK("service_desk"), 
        /**
         * A core project.
         */
        BUSINESS("business");
        /**
         * The project type as used by Jira's APIs.
         */
        public final String text;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ProjectType(final String text) {
            this.text = text;
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectDetailsDto() {
    }

    /**
     * The URLs of the project's avatars.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonObject getAvatarUrls() {
        return this.avatarUrls;
    }

    /**
     * The ID of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * The key of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKey() {
        return this.key;
    }

    /**
     * The name of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * The category the project belongs to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectCategoryDto getProjectCategory() {
        return this.projectCategory;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelf() {
        return this.self;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSimplified() {
        return this.simplified;
    }

    /**
     * The URLs of the project's avatars.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAvatarUrls(final JsonObject avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    /**
     * The ID of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * The key of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKey(final String key) {
        this.key = key;
    }

    /**
     * The name of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * The category the project belongs to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProjectCategory(final ProjectCategoryDto projectCategory) {
        this.projectCategory = projectCategory;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelf(final String self) {
        this.self = self;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSimplified(final Boolean simplified) {
        this.simplified = simplified;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ProjectDetailsDto)) return false;
        final ProjectDetailsDto other = (ProjectDetailsDto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$simplified = this.getSimplified();
        final java.lang.Object other$simplified = other.getSimplified();
        if (this$simplified == null ? other$simplified != null : !this$simplified.equals(other$simplified)) return false;
        final java.lang.Object this$avatarUrls = this.getAvatarUrls();
        final java.lang.Object other$avatarUrls = other.getAvatarUrls();
        if (this$avatarUrls == null ? other$avatarUrls != null : !this$avatarUrls.equals(other$avatarUrls)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$key = this.getKey();
        final java.lang.Object other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$projectCategory = this.getProjectCategory();
        final java.lang.Object other$projectCategory = other.getProjectCategory();
        if (this$projectCategory == null ? other$projectCategory != null : !this$projectCategory.equals(other$projectCategory)) return false;
        final java.lang.Object this$projectTypeKey = this.getProjectTypeKey();
        final java.lang.Object other$projectTypeKey = other.getProjectTypeKey();
        if (this$projectTypeKey == null ? other$projectTypeKey != null : !this$projectTypeKey.equals(other$projectTypeKey)) return false;
        final java.lang.Object this$self = this.getSelf();
        final java.lang.Object other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ProjectDetailsDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $simplified = this.getSimplified();
        result = result * PRIME + ($simplified == null ? 43 : $simplified.hashCode());
        final java.lang.Object $avatarUrls = this.getAvatarUrls();
        result = result * PRIME + ($avatarUrls == null ? 43 : $avatarUrls.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $key = this.getKey();
        result = result * PRIME + ($key == null ? 43 : $key.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $projectCategory = this.getProjectCategory();
        result = result * PRIME + ($projectCategory == null ? 43 : $projectCategory.hashCode());
        final java.lang.Object $projectTypeKey = this.getProjectTypeKey();
        result = result * PRIME + ($projectTypeKey == null ? 43 : $projectTypeKey.hashCode());
        final java.lang.Object $self = this.getSelf();
        result = result * PRIME + ($self == null ? 43 : $self.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ProjectDetailsDto(avatarUrls=" + this.getAvatarUrls() + ", id=" + this.getId() + ", key=" + this.getKey() + ", name=" + this.getName() + ", projectCategory=" + this.getProjectCategory() + ", projectTypeKey=" + this.getProjectTypeKey() + ", self=" + this.getSelf() + ", simplified=" + this.getSimplified() + ")";
    }
}
