// Generated by delombok at Mon Apr 08 15:08:11 UTC 2024
package de.qytera.qtaf.xray.entity;

import java.util.ArrayList;
import java.util.List;

/**
 * Xray test execution info entity.
 *
 * @see <a href="https://docs.getxray.app/display/XRAY/Import+Execution+Results#ImportExecutionResults-XrayJSONSchema">Xray Server JSON format</a>
 * @see <a href="https://docs.getxray.app/display/XRAYCLOUD/Using+Xray+JSON+format+to+import+execution+results">Xray Cloud JSON format</a>
 */
public class XrayTestExecutionInfoEntity {
    /**
     * The project key where the test execution will be created.
     */
    private String project;
    /**
     * The summary for the test execution issue.
     */
    private String summary;
    /**
     * The description for the test execution issue.
     */
    private String description;
    /**
     * The version name for the Fix Version field of the test execution issue.
     */
    private String version;
    /**
     * A revision for the revision custom field.
     */
    private String revision;
    /**
     * The username for the Jira user who executed the tests.
     */
    private String user;
    /**
     * The start date for the test execution issue.
     */
    private String startDate;
    /**
     * The finish date for the test execution issue.
     */
    private String finishDate;
    /**
     * The test plan key for associating the test execution issue.
     */
    private String testPlanKey;
    /**
     * The test environments for the test execution issue.
     */
    private List<String> testEnvironments = new ArrayList<>();

    /**
     * Add a test environment to the list of test environments. The provided environment string is modified such that
     * it will be displayed correctly in Xray (e.g. whitespace will be removed).
     *
     * @param environment a test environment
     */
    public void addTestEnvironment(String environment) {
        // Xray interprets environments containing whitespace as distinct environments.
        testEnvironments.add(environment.replaceAll("\\s+", "-").toLowerCase());
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class XrayTestExecutionInfoEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String project;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String summary;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String version;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String revision;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String user;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String startDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String finishDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String testPlanKey;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> testEnvironments;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        XrayTestExecutionInfoEntityBuilder() {
        }

        /**
         * The project key where the test execution will be created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder project(final String project) {
            this.project = project;
            return this;
        }

        /**
         * The summary for the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder summary(final String summary) {
            this.summary = summary;
            return this;
        }

        /**
         * The description for the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder description(final String description) {
            this.description = description;
            return this;
        }

        /**
         * The version name for the Fix Version field of the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder version(final String version) {
            this.version = version;
            return this;
        }

        /**
         * A revision for the revision custom field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder revision(final String revision) {
            this.revision = revision;
            return this;
        }

        /**
         * The username for the Jira user who executed the tests.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder user(final String user) {
            this.user = user;
            return this;
        }

        /**
         * The start date for the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder startDate(final String startDate) {
            this.startDate = startDate;
            return this;
        }

        /**
         * The finish date for the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder finishDate(final String finishDate) {
            this.finishDate = finishDate;
            return this;
        }

        /**
         * The test plan key for associating the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder testPlanKey(final String testPlanKey) {
            this.testPlanKey = testPlanKey;
            return this;
        }

        /**
         * The test environments for the test execution issue.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder testEnvironments(final List<String> testEnvironments) {
            this.testEnvironments = testEnvironments;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public XrayTestExecutionInfoEntity build() {
            return new XrayTestExecutionInfoEntity(this.project, this.summary, this.description, this.version, this.revision, this.user, this.startDate, this.finishDate, this.testPlanKey, this.testEnvironments);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder(project=" + this.project + ", summary=" + this.summary + ", description=" + this.description + ", version=" + this.version + ", revision=" + this.revision + ", user=" + this.user + ", startDate=" + this.startDate + ", finishDate=" + this.finishDate + ", testPlanKey=" + this.testPlanKey + ", testEnvironments=" + this.testEnvironments + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder builder() {
        return new XrayTestExecutionInfoEntity.XrayTestExecutionInfoEntityBuilder();
    }

    /**
     * The project key where the test execution will be created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProject() {
        return this.project;
    }

    /**
     * The summary for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSummary() {
        return this.summary;
    }

    /**
     * The description for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * The version name for the Fix Version field of the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * A revision for the revision custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRevision() {
        return this.revision;
    }

    /**
     * The username for the Jira user who executed the tests.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUser() {
        return this.user;
    }

    /**
     * The start date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStartDate() {
        return this.startDate;
    }

    /**
     * The finish date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFinishDate() {
        return this.finishDate;
    }

    /**
     * The test plan key for associating the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTestPlanKey() {
        return this.testPlanKey;
    }

    /**
     * The test environments for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getTestEnvironments() {
        return this.testEnvironments;
    }

    /**
     * The project key where the test execution will be created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProject(final String project) {
        this.project = project;
    }

    /**
     * The summary for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSummary(final String summary) {
        this.summary = summary;
    }

    /**
     * The description for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
        this.description = description;
    }

    /**
     * The version name for the Fix Version field of the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVersion(final String version) {
        this.version = version;
    }

    /**
     * A revision for the revision custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRevision(final String revision) {
        this.revision = revision;
    }

    /**
     * The username for the Jira user who executed the tests.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUser(final String user) {
        this.user = user;
    }

    /**
     * The start date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStartDate(final String startDate) {
        this.startDate = startDate;
    }

    /**
     * The finish date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinishDate(final String finishDate) {
        this.finishDate = finishDate;
    }

    /**
     * The test plan key for associating the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTestPlanKey(final String testPlanKey) {
        this.testPlanKey = testPlanKey;
    }

    /**
     * The test environments for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTestEnvironments(final List<String> testEnvironments) {
        this.testEnvironments = testEnvironments;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof XrayTestExecutionInfoEntity)) return false;
        final XrayTestExecutionInfoEntity other = (XrayTestExecutionInfoEntity) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$project = this.getProject();
        final java.lang.Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) return false;
        final java.lang.Object this$summary = this.getSummary();
        final java.lang.Object other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        final java.lang.Object this$revision = this.getRevision();
        final java.lang.Object other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !this$revision.equals(other$revision)) return false;
        final java.lang.Object this$user = this.getUser();
        final java.lang.Object other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) return false;
        final java.lang.Object this$startDate = this.getStartDate();
        final java.lang.Object other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
        final java.lang.Object this$finishDate = this.getFinishDate();
        final java.lang.Object other$finishDate = other.getFinishDate();
        if (this$finishDate == null ? other$finishDate != null : !this$finishDate.equals(other$finishDate)) return false;
        final java.lang.Object this$testPlanKey = this.getTestPlanKey();
        final java.lang.Object other$testPlanKey = other.getTestPlanKey();
        if (this$testPlanKey == null ? other$testPlanKey != null : !this$testPlanKey.equals(other$testPlanKey)) return false;
        final java.lang.Object this$testEnvironments = this.getTestEnvironments();
        final java.lang.Object other$testEnvironments = other.getTestEnvironments();
        if (this$testEnvironments == null ? other$testEnvironments != null : !this$testEnvironments.equals(other$testEnvironments)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof XrayTestExecutionInfoEntity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $project = this.getProject();
        result = result * PRIME + ($project == null ? 43 : $project.hashCode());
        final java.lang.Object $summary = this.getSummary();
        result = result * PRIME + ($summary == null ? 43 : $summary.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final java.lang.Object $revision = this.getRevision();
        result = result * PRIME + ($revision == null ? 43 : $revision.hashCode());
        final java.lang.Object $user = this.getUser();
        result = result * PRIME + ($user == null ? 43 : $user.hashCode());
        final java.lang.Object $startDate = this.getStartDate();
        result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
        final java.lang.Object $finishDate = this.getFinishDate();
        result = result * PRIME + ($finishDate == null ? 43 : $finishDate.hashCode());
        final java.lang.Object $testPlanKey = this.getTestPlanKey();
        result = result * PRIME + ($testPlanKey == null ? 43 : $testPlanKey.hashCode());
        final java.lang.Object $testEnvironments = this.getTestEnvironments();
        result = result * PRIME + ($testEnvironments == null ? 43 : $testEnvironments.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "XrayTestExecutionInfoEntity(project=" + this.getProject() + ", summary=" + this.getSummary() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", revision=" + this.getRevision() + ", user=" + this.getUser() + ", startDate=" + this.getStartDate() + ", finishDate=" + this.getFinishDate() + ", testPlanKey=" + this.getTestPlanKey() + ", testEnvironments=" + this.getTestEnvironments() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public XrayTestExecutionInfoEntity(final String project, final String summary, final String description, final String version, final String revision, final String user, final String startDate, final String finishDate, final String testPlanKey, final List<String> testEnvironments) {
        this.project = project;
        this.summary = summary;
        this.description = description;
        this.version = version;
        this.revision = revision;
        this.user = user;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.testPlanKey = testPlanKey;
        this.testEnvironments = testEnvironments;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public XrayTestExecutionInfoEntity() {
    }
}
