// Generated by delombok at Wed Apr 24 11:27:46 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

/**
 * The response when retrieving project data for a specific Jira project.
 *
 * @param <U> the user type
 * @param <I> the issue type
 * @param <V> the version type
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-projects/#api-rest-api-3-project-projectidorkey-get">Get project (Jira Cloud)</a>
 * @see <a href="https://docs.atlassian.com/software/jira/docs/api/REST/9.8.0/#api/2/project-getProject">Get project (Jira Server)</a>
 */
public abstract class ProjectDto<U extends UserDto<?, ?>, I extends IssueTypeDto, V extends VersionDto> {
    /**
     * Expand options that include additional project details in the response.
     */
    private String expand;
    /**
     * The URL of the project details.
     */
    private String self;
    /**
     * The ID of the project.
     */
    private String id;
    /**
     * The key of the project.
     */
    private String key;
    /**
     * A brief description of the project.
     */
    private String description;
    /**
     * The username of the project lead.
     */
    private U lead;
    /**
     * List of the components contained in the project.
     */
    private List<ComponentDto<U>> components = new ArrayList<>();
    /**
     * List of the issue types available in the project.
     */
    private List<I> issueTypes = new ArrayList<>();
    /**
     * A link to information about this project, such as project documentation.
     */
    private String url;
    /**
     * An email address associated with the project.
     */
    private String email;
    /**
     * The default assignee when creating issues for this project.
     */
    private AssigneeType assigneeType;
    /**
     * The versions defined in the project.
     */
    private List<V> versions = new ArrayList<>();
    /**
     * The name of the project.
     */
    private String name;
    /**
     * The name and self URL for each role defined in the project.
     */
    private JsonObject roles;
    /**
     * The URLs of the project's avatars.
     */
    private JsonObject avatarUrls;
    /**
     * The category the project belongs to.
     */
    private ProjectCategoryDto projectCategory;
    /**
     * The <a href="https://support.atlassian.com/jira-work-management/docs/what-is-the-jira-family-of-applications/#Jiraapplicationsoverview-Productfeaturesandprojecttypes">project type</a>
     * of the project.
     */
    private String projectTypeKey;
    /**
     * Whether the project is archived.
     */
    private Boolean archived;


    /**
     * The default assignee when creating issues for this project.
     */
    public enum AssigneeType {
        /**
         * The project's lead user.
         */
        PROJECT_LEAD, 
        /**
         * No user.
         */
        UNASSIGNED;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectDto() {
    }

    /**
     * Expand options that include additional project details in the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExpand() {
        return this.expand;
    }

    /**
     * The URL of the project details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelf() {
        return this.self;
    }

    /**
     * The ID of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * The key of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getKey() {
        return this.key;
    }

    /**
     * A brief description of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * The username of the project lead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public U getLead() {
        return this.lead;
    }

    /**
     * List of the components contained in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ComponentDto<U>> getComponents() {
        return this.components;
    }

    /**
     * List of the issue types available in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<I> getIssueTypes() {
        return this.issueTypes;
    }

    /**
     * A link to information about this project, such as project documentation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * An email address associated with the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmail() {
        return this.email;
    }

    /**
     * The default assignee when creating issues for this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AssigneeType getAssigneeType() {
        return this.assigneeType;
    }

    /**
     * The versions defined in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<V> getVersions() {
        return this.versions;
    }

    /**
     * The name of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * The name and self URL for each role defined in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonObject getRoles() {
        return this.roles;
    }

    /**
     * The URLs of the project's avatars.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonObject getAvatarUrls() {
        return this.avatarUrls;
    }

    /**
     * The category the project belongs to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProjectCategoryDto getProjectCategory() {
        return this.projectCategory;
    }

    /**
     * The <a href="https://support.atlassian.com/jira-work-management/docs/what-is-the-jira-family-of-applications/#Jiraapplicationsoverview-Productfeaturesandprojecttypes">project type</a>
     * of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectTypeKey() {
        return this.projectTypeKey;
    }

    /**
     * Whether the project is archived.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getArchived() {
        return this.archived;
    }

    /**
     * Expand options that include additional project details in the response.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpand(final String expand) {
        this.expand = expand;
    }

    /**
     * The URL of the project details.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelf(final String self) {
        this.self = self;
    }

    /**
     * The ID of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * The key of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setKey(final String key) {
        this.key = key;
    }

    /**
     * A brief description of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
        this.description = description;
    }

    /**
     * The username of the project lead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLead(final U lead) {
        this.lead = lead;
    }

    /**
     * List of the components contained in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setComponents(final List<ComponentDto<U>> components) {
        this.components = components;
    }

    /**
     * List of the issue types available in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssueTypes(final List<I> issueTypes) {
        this.issueTypes = issueTypes;
    }

    /**
     * A link to information about this project, such as project documentation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUrl(final String url) {
        this.url = url;
    }

    /**
     * An email address associated with the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEmail(final String email) {
        this.email = email;
    }

    /**
     * The default assignee when creating issues for this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAssigneeType(final AssigneeType assigneeType) {
        this.assigneeType = assigneeType;
    }

    /**
     * The versions defined in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVersions(final List<V> versions) {
        this.versions = versions;
    }

    /**
     * The name of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * The name and self URL for each role defined in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRoles(final JsonObject roles) {
        this.roles = roles;
    }

    /**
     * The URLs of the project's avatars.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAvatarUrls(final JsonObject avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    /**
     * The category the project belongs to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProjectCategory(final ProjectCategoryDto projectCategory) {
        this.projectCategory = projectCategory;
    }

    /**
     * The <a href="https://support.atlassian.com/jira-work-management/docs/what-is-the-jira-family-of-applications/#Jiraapplicationsoverview-Productfeaturesandprojecttypes">project type</a>
     * of the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProjectTypeKey(final String projectTypeKey) {
        this.projectTypeKey = projectTypeKey;
    }

    /**
     * Whether the project is archived.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setArchived(final Boolean archived) {
        this.archived = archived;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ProjectDto)) return false;
        final ProjectDto<?, ?, ?> other = (ProjectDto<?, ?, ?>) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$archived = this.getArchived();
        final java.lang.Object other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !this$archived.equals(other$archived)) return false;
        final java.lang.Object this$expand = this.getExpand();
        final java.lang.Object other$expand = other.getExpand();
        if (this$expand == null ? other$expand != null : !this$expand.equals(other$expand)) return false;
        final java.lang.Object this$self = this.getSelf();
        final java.lang.Object other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$key = this.getKey();
        final java.lang.Object other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$lead = this.getLead();
        final java.lang.Object other$lead = other.getLead();
        if (this$lead == null ? other$lead != null : !this$lead.equals(other$lead)) return false;
        final java.lang.Object this$components = this.getComponents();
        final java.lang.Object other$components = other.getComponents();
        if (this$components == null ? other$components != null : !this$components.equals(other$components)) return false;
        final java.lang.Object this$issueTypes = this.getIssueTypes();
        final java.lang.Object other$issueTypes = other.getIssueTypes();
        if (this$issueTypes == null ? other$issueTypes != null : !this$issueTypes.equals(other$issueTypes)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        final java.lang.Object this$email = this.getEmail();
        final java.lang.Object other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) return false;
        final java.lang.Object this$assigneeType = this.getAssigneeType();
        final java.lang.Object other$assigneeType = other.getAssigneeType();
        if (this$assigneeType == null ? other$assigneeType != null : !this$assigneeType.equals(other$assigneeType)) return false;
        final java.lang.Object this$versions = this.getVersions();
        final java.lang.Object other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !this$versions.equals(other$versions)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$roles = this.getRoles();
        final java.lang.Object other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !this$roles.equals(other$roles)) return false;
        final java.lang.Object this$avatarUrls = this.getAvatarUrls();
        final java.lang.Object other$avatarUrls = other.getAvatarUrls();
        if (this$avatarUrls == null ? other$avatarUrls != null : !this$avatarUrls.equals(other$avatarUrls)) return false;
        final java.lang.Object this$projectCategory = this.getProjectCategory();
        final java.lang.Object other$projectCategory = other.getProjectCategory();
        if (this$projectCategory == null ? other$projectCategory != null : !this$projectCategory.equals(other$projectCategory)) return false;
        final java.lang.Object this$projectTypeKey = this.getProjectTypeKey();
        final java.lang.Object other$projectTypeKey = other.getProjectTypeKey();
        if (this$projectTypeKey == null ? other$projectTypeKey != null : !this$projectTypeKey.equals(other$projectTypeKey)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ProjectDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $archived = this.getArchived();
        result = result * PRIME + ($archived == null ? 43 : $archived.hashCode());
        final java.lang.Object $expand = this.getExpand();
        result = result * PRIME + ($expand == null ? 43 : $expand.hashCode());
        final java.lang.Object $self = this.getSelf();
        result = result * PRIME + ($self == null ? 43 : $self.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $key = this.getKey();
        result = result * PRIME + ($key == null ? 43 : $key.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $lead = this.getLead();
        result = result * PRIME + ($lead == null ? 43 : $lead.hashCode());
        final java.lang.Object $components = this.getComponents();
        result = result * PRIME + ($components == null ? 43 : $components.hashCode());
        final java.lang.Object $issueTypes = this.getIssueTypes();
        result = result * PRIME + ($issueTypes == null ? 43 : $issueTypes.hashCode());
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        final java.lang.Object $email = this.getEmail();
        result = result * PRIME + ($email == null ? 43 : $email.hashCode());
        final java.lang.Object $assigneeType = this.getAssigneeType();
        result = result * PRIME + ($assigneeType == null ? 43 : $assigneeType.hashCode());
        final java.lang.Object $versions = this.getVersions();
        result = result * PRIME + ($versions == null ? 43 : $versions.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $roles = this.getRoles();
        result = result * PRIME + ($roles == null ? 43 : $roles.hashCode());
        final java.lang.Object $avatarUrls = this.getAvatarUrls();
        result = result * PRIME + ($avatarUrls == null ? 43 : $avatarUrls.hashCode());
        final java.lang.Object $projectCategory = this.getProjectCategory();
        result = result * PRIME + ($projectCategory == null ? 43 : $projectCategory.hashCode());
        final java.lang.Object $projectTypeKey = this.getProjectTypeKey();
        result = result * PRIME + ($projectTypeKey == null ? 43 : $projectTypeKey.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ProjectDto(expand=" + this.getExpand() + ", self=" + this.getSelf() + ", id=" + this.getId() + ", key=" + this.getKey() + ", description=" + this.getDescription() + ", lead=" + this.getLead() + ", components=" + this.getComponents() + ", issueTypes=" + this.getIssueTypes() + ", url=" + this.getUrl() + ", email=" + this.getEmail() + ", assigneeType=" + this.getAssigneeType() + ", versions=" + this.getVersions() + ", name=" + this.getName() + ", roles=" + this.getRoles() + ", avatarUrls=" + this.getAvatarUrls() + ", projectCategory=" + this.getProjectCategory() + ", projectTypeKey=" + this.getProjectTypeKey() + ", archived=" + this.getArchived() + ")";
    }
}
