// Generated by delombok at Wed Apr 24 11:27:46 UTC 2024
package de.qytera.qtaf.xray.entity;

import de.qytera.qtaf.core.log.model.error.ErrorLogCollection;
import de.qytera.qtaf.core.util.Base64Helper;
import de.qytera.qtaf.xray.error.EvidenceUploadError;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * Xray evidence item entity.
 *
 * @see <a href="https://docs.getxray.app/display/XRAY/Import+Execution+Results#ImportExecutionResults-XrayJSONSchema">Xray Server JSON format</a>
 * @see <a href="https://docs.getxray.app/display/XRAYCLOUD/Using+Xray+JSON+format+to+import+execution+results">Xray Cloud JSON format</a>
 */
public class XrayEvidenceItemEntity {
    /**
     * The attachment data encoded in <b>base64</b>.
     */
    private final String data;
    /**
     * The file name for the attachment.
     */
    private final String filename;
    /**
     * The Content-Type representation header is used to indicate the original media type of the resource.
     */
    private String contentType;

    /**
     * Transforms the provided file into an evidence entity.
     *
     * @param filepath the path to the file
     * @return a corresponding evidence entity
     */
    public static XrayEvidenceItemEntity fromFile(String filepath) {
        return fromFile(filepath, null);
    }

    /**
     * Transforms the provided file into an evidence entity. If {@code evidenceName} is {@code null}, the name of the
     * provided file will be used as name. Otherwise, the provided name will be used.
     *
     * @param filepath     the path to the file
     * @param evidenceName an optional name to assign to the evidence
     * @return a corresponding evidence entity
     */
    public static XrayEvidenceItemEntity fromFile(String filepath, String evidenceName) {
        try {
            Path path = Paths.get(filepath);
            String filename = evidenceName == null ? path.getFileName().toString() : evidenceName;
            String mimeType = URLConnection.guessContentTypeFromName(filename);
            return XrayEvidenceItemEntity.builder().filename(filename).data(Base64Helper.encodeFileContent(path.toAbsolutePath().toString())).contentType(mimeType).build();
        } catch (IOException | NullPointerException e) {
            EvidenceUploadError error = new EvidenceUploadError(e).setFilepath(filepath);
            ErrorLogCollection.getInstance().addErrorLog(error);
        }
        return null;
    }

    /**
     * Transforms the provided {@code String} data into an evidence entity.
     *
     * @param data         the data to convert into evidence
     * @param evidenceName the name to assign to the evidence
     * @return a corresponding evidence entity
     */
    public static XrayEvidenceItemEntity fromString(String data, String evidenceName) {
        try {
            String mimeType = URLConnection.guessContentTypeFromName(evidenceName);
            return XrayEvidenceItemEntity.builder().filename(evidenceName).data(Base64Helper.encode(data)).contentType(mimeType).build();
        } catch (NullPointerException e) {
            ErrorLogCollection.getInstance().addErrorLog(new EvidenceUploadError(e));
        }
        return null;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    XrayEvidenceItemEntity(final String data, final String filename, final String contentType) {
        this.data = data;
        this.filename = filename;
        this.contentType = contentType;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static class XrayEvidenceItemEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String data;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String filename;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String contentType;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        XrayEvidenceItemEntityBuilder() {
        }

        /**
         * The attachment data encoded in <b>base64</b>.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder data(final String data) {
            this.data = data;
            return this;
        }

        /**
         * The file name for the attachment.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder filename(final String filename) {
            this.filename = filename;
            return this;
        }

        /**
         * The Content-Type representation header is used to indicate the original media type of the resource.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder contentType(final String contentType) {
            this.contentType = contentType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private XrayEvidenceItemEntity build() {
            return new XrayEvidenceItemEntity(this.data, this.filename, this.contentType);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder(data=" + this.data + ", filename=" + this.filename + ", contentType=" + this.contentType + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder builder() {
        return new XrayEvidenceItemEntity.XrayEvidenceItemEntityBuilder();
    }

    /**
     * The attachment data encoded in <b>base64</b>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getData() {
        return this.data;
    }

    /**
     * The file name for the attachment.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFilename() {
        return this.filename;
    }

    /**
     * The Content-Type representation header is used to indicate the original media type of the resource.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getContentType() {
        return this.contentType;
    }

    /**
     * The Content-Type representation header is used to indicate the original media type of the resource.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setContentType(final String contentType) {
        this.contentType = contentType;
    }
}
