/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.dto.request.graphql.GraphQLRequestDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayCloudTestStepResponseDto;
import de.qytera.qtaf.xray.dto.response.steps.XrayTestStepResponseDto;
import de.qytera.qtaf.xray.repository.jira.JiraIssueRepository;
import de.qytera.qtaf.xray.repository.xray.XrayTestRepository;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class XrayTestRepositoryCloud
implements XrayTestRepository {
    private static final int GRAPH_QL_QUERY_ISSUES_LIMIT = 100;

    @Override
    public Map<String, XrayTestStepResponseDto[]> getTestSteps(Collection<String> testIssueKeys) throws URISyntaxException, MissingConfigurationValueException {
        String query = "query ($jql: String!, $limit: Int!) {\n  getTests(jql: $jql, limit: $limit) {\n    total\n    limit\n    results {\n      issueId\n      testType {\n        name\n        kind\n      }\n      steps {\n        id\n        data\n        action\n        result\n      }\n    }\n  }\n}\n";
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssue = new HashMap<String, XrayTestStepResponseDto[]>();
        for (int n = 0; n < testIssueKeys.size(); n += 100) {
            List<String> subset = testIssueKeys.stream().skip(n).limit(100L).toList();
            String jql = String.format("issue in (%s)", String.join((CharSequence)",", subset));
            GraphQLRequestDto dto = new GraphQLRequestDto();
            dto.setQuery(query);
            dto.addVariable("jql", jql);
            dto.addVariable("limit", 100);
            RequestBuilder request = WebService.buildRequest((URI)this.getURIGraphQL());
            request.getBuilder().header("Authorization", (Object)this.getXrayAuthorizationHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            String requestData = GsonFactory.getInstance().toJson((Object)dto);
            try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)dto));){
                String responseData = (String)response.readEntity(String.class);
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    stepsByIssue.putAll(this.parseTestStepResponse(requestData, responseData));
                    continue;
                }
                String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to get test steps for issues using query '%s': %s", requestData, reason), new Object[0]);
                break;
            }
        }
        return this.convertIssueIdsToIssueKeys(stepsByIssue, testIssueKeys);
    }

    private URI getURIGraphQL() throws URISyntaxException {
        return new URI(this.getXrayURL() + "/graphql");
    }

    private Map<String, XrayTestStepResponseDto[]> parseTestStepResponse(String request, String response) {
        XrayCloudTestStepResponseDto stepResponse = (XrayCloudTestStepResponseDto)GsonFactory.getInstance().fromJson(response, XrayCloudTestStepResponseDto.class);
        if (stepResponse.hasErrors()) {
            QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to get test steps for issues using query '%s': %s", request, stepResponse.errorReason()), new Object[0]);
            return Collections.emptyMap();
        }
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssue = new HashMap<String, XrayTestStepResponseDto[]>();
        Arrays.stream(((XrayCloudTestStepResponseDto.ResponseData)stepResponse.getData()).getGetTests().getResults()).forEach(r -> stepsByIssue.put(r.getIssueId(), r.getSteps()));
        return stepsByIssue;
    }

    private Map<String, XrayTestStepResponseDto[]> convertIssueIdsToIssueKeys(Map<String, XrayTestStepResponseDto[]> stepsByIssueId, Collection<String> testIssueKeys) throws URISyntaxException, MissingConfigurationValueException {
        Map<String, String> issueIds = JiraIssueRepository.getInstance().getIssueIds(testIssueKeys);
        Map<String, String> testKeysByIssueId = issueIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashMap<String, XrayTestStepResponseDto[]> stepsByIssueKey = new HashMap<String, XrayTestStepResponseDto[]>(stepsByIssueId.size());
        stepsByIssueId.forEach((id, steps) -> stepsByIssueKey.put((String)testKeysByIssueId.get(id), (XrayTestStepResponseDto[])steps));
        return stepsByIssueKey;
    }

    @Generated
    XrayTestRepositoryCloud() {
    }
}

