// Generated by delombok at Wed May 15 08:11:28 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

import java.util.ArrayList;
import java.util.List;

/**
 * The response when retrieving project versions.
 *
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-project-versions/#api-rest-api-3-project-projectidorkey-versions-get">Get project versions (Jira Cloud)</a>
 * @see <a href="https://docs.atlassian.com/software/jira/docs/api/REST/9.8.0/#api/2/project-getProjectVersions">Get project versions (Jira Server)</a>
 */
public abstract class VersionDto {
    /**
     * Use expand to include additional information about version in the response. This parameter accepts a
     * comma-separated list. Expand options include:
     * <dl>
     *     <dt>{@code operations}</dt>
     *     <dd>Returns the list of operations available for this version.</dd>
     *     <dt>{@code issuesstatus}</dt>
     *     <dd>
     *         Returns the count of issues in this version for each of the status categories <i>to do</i>,
     *         <i>in progress</i>, <i>done</i>, and  <i>unmapped</i>. The unmapped property contains a count of issues
     *         with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
     *     </dd>
     * </dl>
     */
    private String expand;
    /**
     * The URL of the version.
     */
    private String self;
    /**
     * The ID of the version.
     */
    private String id;
    /**
     * The description of the version. Optional when creating or updating a version.
     */
    private String description;
    /**
     * The unique name of the version. Required when creating a version. Optional when updating a version. The maximum
     * length is 255 characters.
     */
    private String name;
    /**
     * Indicates that the version is archived. Optional when creating or updating a version.
     */
    private Boolean archived;
    /**
     * Indicates that the version is released. If the version is released a request to release again is ignored. Not
     * applicable when creating a version. Optional when updating a version.
     */
    private Boolean released;
    /**
     * Indicates that the version is overdue.
     */
    private Boolean overdue;
    /**
     * The date on which work on this version is expected to start, expressed in the instance's Day/Month/Year format
     * date format.
     */
    private String userStartDate;
    /**
     * The date on which work on this version is expected to finish, expressed in the instance's Day/Month/Year Format
     * date format.
     */
    private String userReleaseData;
    /**
     * The ID of the project to which this version is attached. Required when creating a version. Not applicable when
     * updating a version.
     */
    private Integer projectId;
    /**
     * The URL of the self link to the version to which all unfixed issues are moved when a version is released.
     * Not applicable when creating a version. Optional when updating a version.
     */
    private String moveUnfixedIssuesTo;
    /**
     * If the expand option {@code operations} is used, returns the list of operations available for this version.
     */
    private List<SimpleLinkDto> operations = new ArrayList<>();

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VersionDto() {
    }

    /**
     * Use expand to include additional information about version in the response. This parameter accepts a
     * comma-separated list. Expand options include:
     * <dl>
     *     <dt>{@code operations}</dt>
     *     <dd>Returns the list of operations available for this version.</dd>
     *     <dt>{@code issuesstatus}</dt>
     *     <dd>
     *         Returns the count of issues in this version for each of the status categories <i>to do</i>,
     *         <i>in progress</i>, <i>done</i>, and  <i>unmapped</i>. The unmapped property contains a count of issues
     *         with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
     *     </dd>
     * </dl>
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getExpand() {
        return this.expand;
    }

    /**
     * The URL of the version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelf() {
        return this.self;
    }

    /**
     * The ID of the version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * The description of the version. Optional when creating or updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * The unique name of the version. Required when creating a version. Optional when updating a version. The maximum
     * length is 255 characters.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Indicates that the version is archived. Optional when creating or updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getArchived() {
        return this.archived;
    }

    /**
     * Indicates that the version is released. If the version is released a request to release again is ignored. Not
     * applicable when creating a version. Optional when updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getReleased() {
        return this.released;
    }

    /**
     * Indicates that the version is overdue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getOverdue() {
        return this.overdue;
    }

    /**
     * The date on which work on this version is expected to start, expressed in the instance's Day/Month/Year format
     * date format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserStartDate() {
        return this.userStartDate;
    }

    /**
     * The date on which work on this version is expected to finish, expressed in the instance's Day/Month/Year Format
     * date format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserReleaseData() {
        return this.userReleaseData;
    }

    /**
     * The ID of the project to which this version is attached. Required when creating a version. Not applicable when
     * updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * The URL of the self link to the version to which all unfixed issues are moved when a version is released.
     * Not applicable when creating a version. Optional when updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMoveUnfixedIssuesTo() {
        return this.moveUnfixedIssuesTo;
    }

    /**
     * If the expand option {@code operations} is used, returns the list of operations available for this version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<SimpleLinkDto> getOperations() {
        return this.operations;
    }

    /**
     * Use expand to include additional information about version in the response. This parameter accepts a
     * comma-separated list. Expand options include:
     * <dl>
     *     <dt>{@code operations}</dt>
     *     <dd>Returns the list of operations available for this version.</dd>
     *     <dt>{@code issuesstatus}</dt>
     *     <dd>
     *         Returns the count of issues in this version for each of the status categories <i>to do</i>,
     *         <i>in progress</i>, <i>done</i>, and  <i>unmapped</i>. The unmapped property contains a count of issues
     *         with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
     *     </dd>
     * </dl>
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setExpand(final String expand) {
        this.expand = expand;
    }

    /**
     * The URL of the version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelf(final String self) {
        this.self = self;
    }

    /**
     * The ID of the version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * The description of the version. Optional when creating or updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
        this.description = description;
    }

    /**
     * The unique name of the version. Required when creating a version. Optional when updating a version. The maximum
     * length is 255 characters.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * Indicates that the version is archived. Optional when creating or updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setArchived(final Boolean archived) {
        this.archived = archived;
    }

    /**
     * Indicates that the version is released. If the version is released a request to release again is ignored. Not
     * applicable when creating a version. Optional when updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReleased(final Boolean released) {
        this.released = released;
    }

    /**
     * Indicates that the version is overdue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOverdue(final Boolean overdue) {
        this.overdue = overdue;
    }

    /**
     * The date on which work on this version is expected to start, expressed in the instance's Day/Month/Year format
     * date format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserStartDate(final String userStartDate) {
        this.userStartDate = userStartDate;
    }

    /**
     * The date on which work on this version is expected to finish, expressed in the instance's Day/Month/Year Format
     * date format.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUserReleaseData(final String userReleaseData) {
        this.userReleaseData = userReleaseData;
    }

    /**
     * The ID of the project to which this version is attached. Required when creating a version. Not applicable when
     * updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProjectId(final Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * The URL of the self link to the version to which all unfixed issues are moved when a version is released.
     * Not applicable when creating a version. Optional when updating a version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMoveUnfixedIssuesTo(final String moveUnfixedIssuesTo) {
        this.moveUnfixedIssuesTo = moveUnfixedIssuesTo;
    }

    /**
     * If the expand option {@code operations} is used, returns the list of operations available for this version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setOperations(final List<SimpleLinkDto> operations) {
        this.operations = operations;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VersionDto)) return false;
        final VersionDto other = (VersionDto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$archived = this.getArchived();
        final java.lang.Object other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !this$archived.equals(other$archived)) return false;
        final java.lang.Object this$released = this.getReleased();
        final java.lang.Object other$released = other.getReleased();
        if (this$released == null ? other$released != null : !this$released.equals(other$released)) return false;
        final java.lang.Object this$overdue = this.getOverdue();
        final java.lang.Object other$overdue = other.getOverdue();
        if (this$overdue == null ? other$overdue != null : !this$overdue.equals(other$overdue)) return false;
        final java.lang.Object this$projectId = this.getProjectId();
        final java.lang.Object other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) return false;
        final java.lang.Object this$expand = this.getExpand();
        final java.lang.Object other$expand = other.getExpand();
        if (this$expand == null ? other$expand != null : !this$expand.equals(other$expand)) return false;
        final java.lang.Object this$self = this.getSelf();
        final java.lang.Object other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$userStartDate = this.getUserStartDate();
        final java.lang.Object other$userStartDate = other.getUserStartDate();
        if (this$userStartDate == null ? other$userStartDate != null : !this$userStartDate.equals(other$userStartDate)) return false;
        final java.lang.Object this$userReleaseData = this.getUserReleaseData();
        final java.lang.Object other$userReleaseData = other.getUserReleaseData();
        if (this$userReleaseData == null ? other$userReleaseData != null : !this$userReleaseData.equals(other$userReleaseData)) return false;
        final java.lang.Object this$moveUnfixedIssuesTo = this.getMoveUnfixedIssuesTo();
        final java.lang.Object other$moveUnfixedIssuesTo = other.getMoveUnfixedIssuesTo();
        if (this$moveUnfixedIssuesTo == null ? other$moveUnfixedIssuesTo != null : !this$moveUnfixedIssuesTo.equals(other$moveUnfixedIssuesTo)) return false;
        final java.lang.Object this$operations = this.getOperations();
        final java.lang.Object other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !this$operations.equals(other$operations)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VersionDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $archived = this.getArchived();
        result = result * PRIME + ($archived == null ? 43 : $archived.hashCode());
        final java.lang.Object $released = this.getReleased();
        result = result * PRIME + ($released == null ? 43 : $released.hashCode());
        final java.lang.Object $overdue = this.getOverdue();
        result = result * PRIME + ($overdue == null ? 43 : $overdue.hashCode());
        final java.lang.Object $projectId = this.getProjectId();
        result = result * PRIME + ($projectId == null ? 43 : $projectId.hashCode());
        final java.lang.Object $expand = this.getExpand();
        result = result * PRIME + ($expand == null ? 43 : $expand.hashCode());
        final java.lang.Object $self = this.getSelf();
        result = result * PRIME + ($self == null ? 43 : $self.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $userStartDate = this.getUserStartDate();
        result = result * PRIME + ($userStartDate == null ? 43 : $userStartDate.hashCode());
        final java.lang.Object $userReleaseData = this.getUserReleaseData();
        result = result * PRIME + ($userReleaseData == null ? 43 : $userReleaseData.hashCode());
        final java.lang.Object $moveUnfixedIssuesTo = this.getMoveUnfixedIssuesTo();
        result = result * PRIME + ($moveUnfixedIssuesTo == null ? 43 : $moveUnfixedIssuesTo.hashCode());
        final java.lang.Object $operations = this.getOperations();
        result = result * PRIME + ($operations == null ? 43 : $operations.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "VersionDto(expand=" + this.getExpand() + ", self=" + this.getSelf() + ", id=" + this.getId() + ", description=" + this.getDescription() + ", name=" + this.getName() + ", archived=" + this.getArchived() + ", released=" + this.getReleased() + ", overdue=" + this.getOverdue() + ", userStartDate=" + this.getUserStartDate() + ", userReleaseData=" + this.getUserReleaseData() + ", projectId=" + this.getProjectId() + ", moveUnfixedIssuesTo=" + this.getMoveUnfixedIssuesTo() + ", operations=" + this.getOperations() + ")";
    }
}
