/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.builder.test;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.core.log.model.collection.TestSuiteLogCollection;
import de.qytera.qtaf.core.log.model.message.StepInformationLogMessage;
import de.qytera.qtaf.xray.annotation.XrayTest;
import de.qytera.qtaf.xray.builder.XrayJsonHelper;
import de.qytera.qtaf.xray.builder.test.XrayTestEntityBuilder;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.config.XrayStatusHelper;
import de.qytera.qtaf.xray.entity.XrayCustomFieldEntity;
import de.qytera.qtaf.xray.entity.XrayEvidenceItemEntity;
import de.qytera.qtaf.xray.entity.XrayIterationParameterEntity;
import de.qytera.qtaf.xray.entity.XrayIterationResultEntity;
import de.qytera.qtaf.xray.entity.XrayIterationResultEntityCloud;
import de.qytera.qtaf.xray.entity.XrayIterationResultEntityServer;
import de.qytera.qtaf.xray.entity.XrayManualTestStepResultEntity;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntity;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntityCloud;
import de.qytera.qtaf.xray.entity.XrayTestInfoEntityServer;
import de.qytera.qtaf.xray.entity.XrayTestStepEntity;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.util.Strings;

public class MultipleIterationsXrayTestEntityBuilder
extends XrayTestEntityBuilder<List<TestScenarioLogCollection>> {
    public MultipleIterationsXrayTestEntityBuilder(@NonNull TestSuiteLogCollection collection, @NonNull Map<String, String> issueSummaries) {
        super(collection, issueSummaries);
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (issueSummaries == null) {
            throw new NullPointerException("issueSummaries is marked non-null but is null");
        }
    }

    @Override
    protected TestScenarioLogCollection.Status getStatus(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return XrayStatusHelper.combinedScenarioStatus(scenarioLogs);
    }

    @Override
    protected XrayTestInfoEntity getTestInfo(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        XrayTestInfoEntity entity = null;
        if (XrayConfigHelper.shouldResultsUploadTestsInfoStepsUpdate()) {
            String projectKey = XrayConfigHelper.getProjectKey();
            String summary = this.issueSummaries.get(xrayTest.key()) != null && !((String)this.issueSummaries.get(xrayTest.key())).isBlank() ? (String)this.issueSummaries.get(xrayTest.key()) : "no summary";
            entity = XrayConfigHelper.isXrayCloudService() ? ((XrayTestInfoEntityCloud.XrayTestInfoEntityCloudBuilder)((XrayTestInfoEntity.XrayTestInfoEntityBuilder)((XrayTestInfoEntityCloud.XrayTestInfoEntityCloudBuilder)((XrayTestInfoEntityCloud.XrayTestInfoEntityCloudBuilder)XrayTestInfoEntityCloud.builder().projectKey(projectKey)).summary(summary)).type("Manual")).steps(new ArrayList<XrayTestStepEntity>())).build() : ((XrayTestInfoEntityServer.XrayTestInfoEntityServerBuilder)((XrayTestInfoEntity.XrayTestInfoEntityBuilder)((XrayTestInfoEntityServer.XrayTestInfoEntityServerBuilder)((XrayTestInfoEntityServer.XrayTestInfoEntityServerBuilder)XrayTestInfoEntityServer.builder().summary(summary)).projectKey(projectKey)).testType("Manual")).steps(new ArrayList<XrayTestStepEntity>())).build();
            if (XrayConfigHelper.shouldResultsUploadTestsInfoStepsMerge()) {
                entity.getSteps().add(MultipleIterationsXrayTestEntityBuilder.buildMergedTestInfoStepEntity(scenarioLogs));
            } else {
                entity.setSteps(MultipleIterationsXrayTestEntityBuilder.buildTestInfoStepEntities(xrayTest, scenarioLogs));
            }
        }
        return entity;
    }

    @Override
    protected Date getStartDate(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        Date start = null;
        for (TestScenarioLogCollection scenarioLog : scenarioLogs) {
            if (start != null && !scenarioLog.getStart().before(start)) continue;
            start = scenarioLog.getStart();
        }
        return start;
    }

    @Override
    protected Date getEndDate(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        Date end = null;
        for (TestScenarioLogCollection scenarioLog : scenarioLogs) {
            if (end != null && !scenarioLog.getEnd().after(end)) continue;
            end = scenarioLog.getEnd();
        }
        return end;
    }

    @Override
    protected String getComment(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return null;
    }

    @Override
    protected String getExecutedBy(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return null;
    }

    @Override
    protected String getAssignee(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return null;
    }

    @Override
    protected List<XrayManualTestStepResultEntity> getSteps(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getExamples(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return Collections.emptyList();
    }

    @Override
    protected List<XrayIterationResultEntity> getIterations(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        ArrayList<XrayIterationResultEntity> iterations = new ArrayList<XrayIterationResultEntity>(scenarioLogs.size());
        for (int i = 0; i < scenarioLogs.size(); ++i) {
            TestScenarioLogCollection scenarioLog = scenarioLogs.get(i);
            XrayIterationResultEntity iteration = XrayConfigHelper.isXrayCloudService() ? new XrayIterationResultEntityCloud(scenarioLog.getStatus()) : new XrayIterationResultEntityServer(scenarioLog.getStatus());
            iterations.add(iteration);
            for (TestScenarioLogCollection.TestParameter testParameter : scenarioLog.getTestParameters()) {
                XrayIterationParameterEntity parameterEntity = new XrayIterationParameterEntity();
                parameterEntity.setName(XrayJsonHelper.truncateParameterName(testParameter.getName()));
                parameterEntity.setValue(XrayJsonHelper.truncateParameterValue(testParameter.getValue().toString()));
                iteration.getParameters().add(parameterEntity);
            }
            List steps = scenarioLog.getLogMessages(StepInformationLogMessage.class);
            if (steps.isEmpty()) continue;
            if (XrayConfigHelper.shouldResultsUploadTestsInfoStepsMerge()) {
                if (!XrayConfigHelper.shouldResultsUploadTestsInfoStepsUpdate()) {
                    QtafFactory.getLogger().warn(String.format("The plugin was configured to merge test steps, but not to update test issue steps. This might lead to inconsistencies between the test steps of %s and the steps of test iteration %d!", xrayTest.key(), i + 1), new Object[0]);
                }
                iteration.getSteps().add(MultipleIterationsXrayTestEntityBuilder.buildMergedManualTestStepResultEntity(steps));
                continue;
            }
            steps.stream().map(XrayTestEntityBuilder::buildManualTestStepResultEntity).forEach(iteration.getSteps()::add);
        }
        return iterations;
    }

    @Override
    protected List<String> getDefects(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return Collections.emptyList();
    }

    @Override
    protected List<XrayEvidenceItemEntity> getEvidence(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        ArrayList<XrayEvidenceItemEntity> evidence = new ArrayList<XrayEvidenceItemEntity>();
        int i = 1;
        for (TestScenarioLogCollection scenario : scenarioLogs) {
            if (XrayConfigHelper.isScenarioReportEvidenceEnabled() && xrayTest.scenarioReport()) {
                Writer renderedTemplate = this.reportCreator.getRenderedTemplate(this.collection, scenario);
                String filename = "scenario_" + scenario.getScenarioId() + "_" + i + ".html";
                evidence.add(XrayEvidenceItemEntity.fromString(renderedTemplate.toString(), filename));
            }
            if (XrayConfigHelper.isScenarioImageEvidenceEnabled() && xrayTest.screenshots()) {
                for (String filepath : scenario.getScreenshotPaths()) {
                    evidence.add(XrayEvidenceItemEntity.fromFile(filepath));
                }
            }
            ++i;
        }
        return evidence;
    }

    @Override
    protected List<XrayCustomFieldEntity> getCustomFields(XrayTest xrayTest, List<TestScenarioLogCollection> scenarioLogs) {
        return Collections.emptyList();
    }

    private static List<XrayTestStepEntity> buildTestInfoStepEntities(XrayTest xrayTest, List<TestScenarioLogCollection> iterations) {
        HashSet<Integer> iterationSizes = new HashSet<Integer>();
        Collection longestStepSequence = null;
        for (TestScenarioLogCollection iteration : iterations) {
            List steps = iteration.getLogMessages(StepInformationLogMessage.class);
            iterationSizes.add(steps.size());
            if (longestStepSequence != null && steps.size() <= longestStepSequence.size()) continue;
            longestStepSequence = steps;
        }
        if (longestStepSequence == null) {
            return Collections.emptyList();
        }
        if (iterationSizes.size() != 1) {
            QtafFactory.getLogger().warn(String.format("Iterations of %s have varying numbers of steps: %s. %s", xrayTest.key(), iterationSizes, "The issue's steps might not match the iterations' steps after upload."), new Object[0]);
        }
        return longestStepSequence.stream().map(XrayTestEntityBuilder::buildTestStepEntity).toList();
    }

    private static XrayTestStepEntity buildMergedTestInfoStepEntity(List<TestScenarioLogCollection> iterations) {
        ArrayList<String> linesAction = new ArrayList<String>();
        ArrayList<String> linesData = new ArrayList<String>();
        ArrayList<String> linesResults = new ArrayList<String>();
        for (int i = 0; i < iterations.size(); ++i) {
            linesAction.add(MultipleIterationsXrayTestEntityBuilder.getIterationHeader(iterations, i));
            linesData.add(MultipleIterationsXrayTestEntityBuilder.getIterationHeader(iterations, i));
            linesResults.add(MultipleIterationsXrayTestEntityBuilder.getIterationHeader(iterations, i));
            List steps = iterations.get(i).getLogMessages(StepInformationLogMessage.class);
            XrayTestStepEntity stepEntity = MultipleIterationsXrayTestEntityBuilder.buildMergedTestStepEntity(steps);
            linesAction.add(stepEntity.getAction());
            linesData.add(stepEntity.getData());
            linesResults.add(stepEntity.getResult());
        }
        XrayTestStepEntity mergedStep = new XrayTestStepEntity(Strings.join(linesAction, (char)'\n'));
        mergedStep.setData(Strings.join(linesData, (char)'\n'));
        mergedStep.setResult(Strings.join(linesResults, (char)'\n'));
        return mergedStep;
    }

    private static String getIterationHeader(List<TestScenarioLogCollection> scenarioCollection, int iteration) {
        String iterationDigits = "%0" + String.valueOf(scenarioCollection.size() + 1).length() + "d";
        String headerFormat = String.format("=====> ITERATION %s <=====", iterationDigits);
        return String.format(headerFormat, iteration + 1);
    }
}

