/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.jira;

import com.google.gson.reflect.TypeToken;
import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.jira.ProjectCloudDto;
import de.qytera.qtaf.xray.dto.jira.ProjectDto;
import de.qytera.qtaf.xray.dto.jira.ProjectServerDto;
import de.qytera.qtaf.xray.repository.jira.JiraEndpoint;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;

public class JiraProjectRepository
implements JiraEndpoint {
    private static final JiraProjectRepository INSTANCE = new JiraProjectRepository();

    public static JiraProjectRepository getInstance() {
        return INSTANCE;
    }

    public <P extends ProjectDto<?, ?, ?>> P getProject(String projectIdOrKey) throws URISyntaxException, MissingConfigurationValueException {
        RequestBuilder request = WebService.buildRequest((URI)JiraProjectRepository.getProjectPathURI(projectIdOrKey));
        request.getBuilder().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.getJiraAuthorizationHeaderValue());
        try (Response response = WebService.get((RequestBuilder)request);){
            String responseData = (String)response.readEntity(String.class);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to get project details for project '%s': %s", projectIdOrKey, reason), new Object[0]);
                P p = null;
                return p;
            }
            Type type = XrayConfigHelper.isXrayCloudService() ? TypeToken.get(ProjectCloudDto.class).getType() : TypeToken.get(ProjectServerDto.class).getType();
            ProjectDto projectDto = (ProjectDto)GsonFactory.getInstance().fromJson(responseData, type);
            return (P)projectDto;
        }
    }

    private static URI getProjectPathURI(String projectIdOrKey) throws URISyntaxException {
        if (XrayConfigHelper.isXrayCloudService()) {
            return new URI(String.format("%s/rest/api/3/project/%s", XrayConfigHelper.getJiraUrl(), projectIdOrKey));
        }
        return new URI(String.format("%s/rest/api/2/project/%s", XrayConfigHelper.getJiraUrl(), projectIdOrKey));
    }

    @Generated
    private JiraProjectRepository() {
    }
}

