// Generated by delombok at Wed May 15 15:24:07 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

/**
 * The DTO for Jira Cloud when working with users.
 *
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-users/#api-rest-api-3-user-get">Get user (Jira Cloud)</a>
 */
public class UserCloudDto extends UserDto<ApplicationRoleCloudDto, GroupCloudDto> {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products.
     * For example, 5b10ac8d82e05b22cc7d4ef5. Required in requests.
     */
    private String accountId;
    /**
     * The user account type. Can take the following values:
     * <dl>
     *     <dt>{@code atlassian}</dt>
     *     <dd>regular Atlassian user account</dd>
     *     <dt>{@code app}</dt>
     *     <dd>system account used for Connect applications and OAuth to represent external systems</dd>
     *     <dt>{@code customer}</dt>
     *     <dd>Jira Service Desk account representing an external service desk</dd>
     *     <dt>{@code unknown}</dt>
     *     <dd>everything else</dd>
     * </dl>
     */
    private String accountType;


    /**
     * The user account type.
     */
    public enum AccountType {
        /**
         * A regular Atlassian user account.
         */
        ATLASSIAN("atlassian"), /**
         * A system account used for Connect applications and OAuth to represent external systems.
         */
        APP("app"), /**
         * A Jira Service Desk account representing an external service desk.
         */
        CUSTOMER("customer"), /**
         * An unknown account.
         */
        UNKNOWN("unknown");
        /**
         * The account type.
         */
        public final String text;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AccountType(final String text) {
            this.text = text;
        }
    }

    /**
     * Set the request's account type.
     *
     * @param accountType the account type
     */
    public void setAccountType(AccountType accountType) {
        this.accountType = accountType.text;
    }

    /**
     * Get the account type.
     *
     * @return the account type or null if not set
     */
    public AccountType getAccountType() {
        if (this.accountType == null) {
            return null;
        }
        return AccountType.valueOf(this.accountType.toUpperCase());
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UserCloudDto() {
    }

    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products.
     * For example, 5b10ac8d82e05b22cc7d4ef5. Required in requests.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAccountId() {
        return this.accountId;
    }

    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products.
     * For example, 5b10ac8d82e05b22cc7d4ef5. Required in requests.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAccountId(final String accountId) {
        this.accountId = accountId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "UserCloudDto(accountId=" + this.getAccountId() + ", accountType=" + this.getAccountType() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UserCloudDto)) return false;
        final UserCloudDto other = (UserCloudDto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$accountId = this.getAccountId();
        final java.lang.Object other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) return false;
        final java.lang.Object this$accountType = this.getAccountType();
        final java.lang.Object other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof UserCloudDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $accountId = this.getAccountId();
        result = result * PRIME + ($accountId == null ? 43 : $accountId.hashCode());
        final java.lang.Object $accountType = this.getAccountType();
        result = result * PRIME + ($accountType == null ? 43 : $accountType.hashCode());
        return result;
    }
}
