/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.jira;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.gson.GsonFactory;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.config.XrayConfigHelper;
import de.qytera.qtaf.xray.dto.jira.ApplicationRoleDto;
import de.qytera.qtaf.xray.dto.jira.GroupDto;
import de.qytera.qtaf.xray.dto.jira.IssueUpdateDto;
import de.qytera.qtaf.xray.dto.jira.StatusDto;
import de.qytera.qtaf.xray.dto.jira.TransitionDto;
import de.qytera.qtaf.xray.dto.jira.TransitionsMetaDto;
import de.qytera.qtaf.xray.dto.jira.UserDto;
import de.qytera.qtaf.xray.dto.request.jira.issues.AdditionalField;
import de.qytera.qtaf.xray.dto.request.jira.issues.JiraIssueSearchRequestDto;
import de.qytera.qtaf.xray.dto.response.jira.issues.JiraIssueResponseDto;
import de.qytera.qtaf.xray.dto.response.jira.issues.JiraIssueSearchResponseDto;
import de.qytera.qtaf.xray.repository.jira.JiraEndpoint;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class JiraIssueRepository
implements JiraEndpoint {
    private static final JiraIssueRepository INSTANCE = new JiraIssueRepository();

    public static JiraIssueRepository getInstance() {
        return INSTANCE;
    }

    public List<JiraIssueResponseDto> search(Collection<String> testIssueKeys, AdditionalField ... fields) throws URISyntaxException, MissingConfigurationValueException {
        ArrayList<JiraIssueResponseDto> issues = new ArrayList<JiraIssueResponseDto>();
        JiraIssueSearchRequestDto dto = new JiraIssueSearchRequestDto();
        String jql = String.format("issue in (%s)", String.join((CharSequence)",", testIssueKeys));
        dto.setJql(jql);
        dto.setFields((String[])Arrays.stream(fields).map(AdditionalField::getText).toArray(String[]::new));
        int total = Integer.MAX_VALUE;
        int startAt = 0;
        while (issues.size() != total) {
            dto.setStartAt(startAt);
            RequestBuilder request = WebService.buildRequest((URI)JiraIssueRepository.getURIIssueSearchPath());
            request.getBuilder().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.getJiraAuthorizationHeaderValue());
            try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)dto));){
                String responseData = (String)response.readEntity(String.class);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                    QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to search for Jira issues using search body '%s': %s", GsonFactory.getInstance().toJsonTree((Object)dto), reason), new Object[0]);
                    break;
                }
                JiraIssueSearchResponseDto paginatedResult = (JiraIssueSearchResponseDto)GsonFactory.getInstance().fromJson(responseData, JiraIssueSearchResponseDto.class);
                total = paginatedResult.getTotal();
                issues.addAll(Arrays.asList(paginatedResult.getIssues()));
            }
            startAt = issues.size();
        }
        return issues;
    }

    private static URI getURIIssueSearchPath() throws URISyntaxException {
        if (XrayConfigHelper.isXrayCloudService()) {
            return new URI(XrayConfigHelper.getJiraUrl() + "/rest/api/3/search");
        }
        return new URI(XrayConfigHelper.getJiraUrl() + "/rest/api/2/search");
    }

    public <R extends ApplicationRoleDto, G extends GroupDto, U extends UserDto<R, G>> boolean assign(String issueIdOrKey, U user) throws URISyntaxException, MissingConfigurationValueException {
        RequestBuilder request = WebService.buildRequest((URI)JiraIssueRepository.getAssignURI(issueIdOrKey));
        request.getBuilder().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)this.getJiraAuthorizationHeaderValue());
        try (Response response = WebService.put((RequestBuilder)request, (Entity)Entity.json(user));){
            String responseData = (String)response.readEntity(String.class);
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                String reason = String.format("%d %s: %s", response.getStatus(), response.getStatusInfo().getReasonPhrase(), responseData);
                QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to assign issue '%s' to user '%s': %s", issueIdOrKey, user, reason), new Object[0]);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private static URI getAssignURI(String issueIdOrKey) throws URISyntaxException {
        if (XrayConfigHelper.isXrayCloudService()) {
            return new URI(String.format("%s/rest/api/3/issue/%s/assignee", XrayConfigHelper.getJiraUrl(), issueIdOrKey));
        }
        return new URI(String.format("%s/rest/api/2/issue/%s/assignee", XrayConfigHelper.getJiraUrl(), issueIdOrKey));
    }

    public Map<String, String> getIssueIds(Collection<String> testIssueKeys) throws URISyntaxException, MissingConfigurationValueException {
        HashMap<String, String> issueIds = new HashMap<String, String>();
        List<JiraIssueResponseDto> issues = this.search(testIssueKeys, AdditionalField.ISSUE_KEY, AdditionalField.ID);
        issues.forEach(issue -> issueIds.put(issue.getKey(), issue.getId()));
        return issueIds;
    }

    public boolean transitionIssue(String issueIdOrKey, IssueUpdateDto body) throws MissingConfigurationValueException, URISyntaxException {
        RequestBuilder request = WebService.buildRequest((URI)JiraIssueRepository.getURITransitionIssue(issueIdOrKey));
        request.getBuilder().header("Authorization", (Object)this.getJiraAuthorizationHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        try (Response response = WebService.post((RequestBuilder)request, (Entity)Entity.json((Object)body));){
            String responseJson = (String)response.readEntity(String.class);
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                QtafFactory.getLogger().info(String.format("[QTAF Xray Plugin] Successfully transitioned issue %s to status: %s", issueIdOrKey, body.getTransition()), new Object[0]);
                boolean bl = true;
                return bl;
            }
            QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to transition issue %s to status: %s: %s", issueIdOrKey, body.getTransition(), responseJson), new Object[0]);
        }
        return false;
    }

    public boolean transitionIssue(String issueIdOrKey, String statusName) throws MissingConfigurationValueException, URISyntaxException {
        List<TransitionDto> transitions = this.getIssueTransitions(issueIdOrKey);
        for (TransitionDto transition : transitions) {
            StatusDto status = transition.getTo();
            if (status == null || status.getName() == null || !status.getName().equalsIgnoreCase(statusName)) continue;
            IssueUpdateDto dto = new IssueUpdateDto();
            dto.setTransition(transition);
            return this.transitionIssue(issueIdOrKey, dto);
        }
        QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to transition issue %s to status %s: %s. Possible statuses: %s", issueIdOrKey, statusName, "The workflow prohibits the transition or it does not exist", transitions.stream().map(TransitionDto::getTo).filter(Objects::nonNull).map(StatusDto::getName).collect(Collectors.joining(","))), new Object[0]);
        return false;
    }

    private static URI getURITransitionIssue(String issueIdOrKey) throws URISyntaxException {
        String endpoint = String.format("%s/rest/api/2/issue/%s/transitions", XrayConfigHelper.getJiraUrl(), issueIdOrKey);
        return new URI(endpoint);
    }

    public List<TransitionDto> getIssueTransitions(String issueIdOrKey) throws MissingConfigurationValueException, URISyntaxException {
        RequestBuilder request = WebService.buildRequest((URI)JiraIssueRepository.getURITransitionIssue(issueIdOrKey));
        request.getBuilder().header("Authorization", (Object)this.getJiraAuthorizationHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        try (Response response = WebService.get((RequestBuilder)request);){
            String responseJson = (String)response.readEntity(String.class);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                TransitionsMetaDto dto = (TransitionsMetaDto)GsonFactory.getInstance().fromJson(responseJson, TransitionsMetaDto.class);
                List<TransitionDto> list = dto.getTransitions();
                return list;
            }
            QtafFactory.getLogger().error(String.format("[QTAF Xray Plugin] Failed to get transitions for issue %s: %s", issueIdOrKey, responseJson), new Object[0]);
        }
        return Collections.emptyList();
    }

    @Generated
    private JiraIssueRepository() {
    }
}

