// Generated by delombok at Wed May 29 13:52:50 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

import com.google.gson.JsonObject;

/**
 * The response when retrieving Jira cloud project versions.
 *
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-project-versions/#api-rest-api-3-project-projectidorkey-versions-get">Get project versions (Jira Cloud)</a>
 * @see <a href="https://docs.atlassian.com/software/jira/docs/api/REST/9.8.0/#api/2/project-getProjectVersions">Get project versions (Jira Server)</a>
 */
public class VersionCloudDto extends VersionDto {
    /**
     * If the expand option {@code issuesstatus} is used, returns the count of issues in this version for each of the
     * status categories <i>to do</i>, <i>in progress</i>, <i>done</i>, and <i>unmapped</i>. The unmapped property
     * contains a count of issues with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
     */
    private VersionIssueStatus issuesStatusForFixVersion;


    /**
     * Issue version statuses.
     */
    public static class VersionIssueStatus {
        /**
         * Count of issues with status <i>done</i>.
         */
        private Integer done;
        /**
         * Count of issues with status in <i>progress</i>.
         */
        private Integer inProgress;
        /**
         * Count of issues with status <i>to do</i>.
         */
        private Integer toDo;
        /**
         * Count of issues with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
         */
        private Integer unmapped;
        /**
         * Extra properties of any type may be provided to this object.
         */
        private JsonObject any;
        /**
         * The release date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or
         * updating a version.
         */
        private String releaseDate;
        /**
         * The start date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating
         * a version.
         */
        private String startDate;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public VersionIssueStatus() {
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getDone() {
            return this.done;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getInProgress() {
            return this.inProgress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getToDo() {
            return this.toDo;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getUnmapped() {
            return this.unmapped;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public JsonObject getAny() {
            return this.any;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getReleaseDate() {
            return this.releaseDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getStartDate() {
            return this.startDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setDone(final Integer done) {
            this.done = done;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setInProgress(final Integer inProgress) {
            this.inProgress = inProgress;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setToDo(final Integer toDo) {
            this.toDo = toDo;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUnmapped(final Integer unmapped) {
            this.unmapped = unmapped;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setAny(final JsonObject any) {
            this.any = any;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setReleaseDate(final String releaseDate) {
            this.releaseDate = releaseDate;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setStartDate(final String startDate) {
            this.startDate = startDate;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof VersionCloudDto.VersionIssueStatus)) return false;
            final VersionCloudDto.VersionIssueStatus other = (VersionCloudDto.VersionIssueStatus) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$done = this.getDone();
            final java.lang.Object other$done = other.getDone();
            if (this$done == null ? other$done != null : !this$done.equals(other$done)) return false;
            final java.lang.Object this$inProgress = this.getInProgress();
            final java.lang.Object other$inProgress = other.getInProgress();
            if (this$inProgress == null ? other$inProgress != null : !this$inProgress.equals(other$inProgress)) return false;
            final java.lang.Object this$toDo = this.getToDo();
            final java.lang.Object other$toDo = other.getToDo();
            if (this$toDo == null ? other$toDo != null : !this$toDo.equals(other$toDo)) return false;
            final java.lang.Object this$unmapped = this.getUnmapped();
            final java.lang.Object other$unmapped = other.getUnmapped();
            if (this$unmapped == null ? other$unmapped != null : !this$unmapped.equals(other$unmapped)) return false;
            final java.lang.Object this$any = this.getAny();
            final java.lang.Object other$any = other.getAny();
            if (this$any == null ? other$any != null : !this$any.equals(other$any)) return false;
            final java.lang.Object this$releaseDate = this.getReleaseDate();
            final java.lang.Object other$releaseDate = other.getReleaseDate();
            if (this$releaseDate == null ? other$releaseDate != null : !this$releaseDate.equals(other$releaseDate)) return false;
            final java.lang.Object this$startDate = this.getStartDate();
            final java.lang.Object other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof VersionCloudDto.VersionIssueStatus;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $done = this.getDone();
            result = result * PRIME + ($done == null ? 43 : $done.hashCode());
            final java.lang.Object $inProgress = this.getInProgress();
            result = result * PRIME + ($inProgress == null ? 43 : $inProgress.hashCode());
            final java.lang.Object $toDo = this.getToDo();
            result = result * PRIME + ($toDo == null ? 43 : $toDo.hashCode());
            final java.lang.Object $unmapped = this.getUnmapped();
            result = result * PRIME + ($unmapped == null ? 43 : $unmapped.hashCode());
            final java.lang.Object $any = this.getAny();
            result = result * PRIME + ($any == null ? 43 : $any.hashCode());
            final java.lang.Object $releaseDate = this.getReleaseDate();
            result = result * PRIME + ($releaseDate == null ? 43 : $releaseDate.hashCode());
            final java.lang.Object $startDate = this.getStartDate();
            result = result * PRIME + ($startDate == null ? 43 : $startDate.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "VersionCloudDto.VersionIssueStatus(done=" + this.getDone() + ", inProgress=" + this.getInProgress() + ", toDo=" + this.getToDo() + ", unmapped=" + this.getUnmapped() + ", any=" + this.getAny() + ", releaseDate=" + this.getReleaseDate() + ", startDate=" + this.getStartDate() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VersionCloudDto() {
    }

    /**
     * If the expand option {@code issuesstatus} is used, returns the count of issues in this version for each of the
     * status categories <i>to do</i>, <i>in progress</i>, <i>done</i>, and <i>unmapped</i>. The unmapped property
     * contains a count of issues with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public VersionIssueStatus getIssuesStatusForFixVersion() {
        return this.issuesStatusForFixVersion;
    }

    /**
     * If the expand option {@code issuesstatus} is used, returns the count of issues in this version for each of the
     * status categories <i>to do</i>, <i>in progress</i>, <i>done</i>, and <i>unmapped</i>. The unmapped property
     * contains a count of issues with a status other than <i>to do</i>, <i>in progress</i>, and <i>done</i>.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIssuesStatusForFixVersion(final VersionIssueStatus issuesStatusForFixVersion) {
        this.issuesStatusForFixVersion = issuesStatusForFixVersion;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "VersionCloudDto(issuesStatusForFixVersion=" + this.getIssuesStatusForFixVersion() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof VersionCloudDto)) return false;
        final VersionCloudDto other = (VersionCloudDto) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$issuesStatusForFixVersion = this.getIssuesStatusForFixVersion();
        final java.lang.Object other$issuesStatusForFixVersion = other.getIssuesStatusForFixVersion();
        if (this$issuesStatusForFixVersion == null ? other$issuesStatusForFixVersion != null : !this$issuesStatusForFixVersion.equals(other$issuesStatusForFixVersion)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof VersionCloudDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $issuesStatusForFixVersion = this.getIssuesStatusForFixVersion();
        result = result * PRIME + ($issuesStatusForFixVersion == null ? 43 : $issuesStatusForFixVersion.hashCode());
        return result;
    }
}
