// Generated by delombok at Wed May 29 13:52:50 UTC 2024
package de.qytera.qtaf.xray.dto.request.graphql;

import com.google.gson.JsonObject;
import de.qytera.qtaf.core.gson.GsonFactory;

/**
 * A generic GraphQL request. These are split into a {@code query} property and a {@code variables} property. The
 * {@code variables} property is used in parameterized queries and can contain arbitrary data for each variable.
 *
 * @see <a href="https://graphql.org/learn/queries/">GraphQL documentation</a>
 */
public class GraphQLRequestDto {
    /**
     * The GraphQL query.
     */
    private String query;
    /**
     * A GraphQL variable mapping.
     */
    private JsonObject variables;

    /**
     * Adds a variable and its content to the GraphQL request.
     *
     * @param name  the name of the variable
     * @param value the variable's data
     */
    public void addVariable(String name, Object value) {
        if (variables == null) {
            variables = new JsonObject();
        }
        variables.add(name, GsonFactory.getInstance().toJsonTree(value));
    }

    /**
     * The GraphQL query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuery() {
        return this.query;
    }

    /**
     * A GraphQL variable mapping.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonObject getVariables() {
        return this.variables;
    }

    /**
     * The GraphQL query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setQuery(final String query) {
        this.query = query;
    }

    /**
     * A GraphQL variable mapping.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVariables(final JsonObject variables) {
        this.variables = variables;
    }
}
