// Generated by delombok at Wed Aug 23 15:04:31 UTC 2023
package de.qytera.qtaf.xray.entity;

import java.util.ArrayList;
import java.util.List;

/**
 * Xray test execution info entity.
 *
 * @see <a href="https://docs.getxray.app/display/XRAY/Import+Execution+Results#ImportExecutionResults-XrayJSONSchema">Xray Server JSON format</a>
 * @see <a href="https://docs.getxray.app/display/XRAYCLOUD/Using+Xray+JSON+format+to+import+execution+results">Xray Cloud JSON format</a>
 */
public class XrayTestExecutionInfoEntity {
    /**
     * The project key where the test execution will be created.
     */
    private String project;
    /**
     * The summary for the test execution issue.
     */
    private String summary;
    /**
     * The description for the test execution issue.
     */
    private String description;
    /**
     * The version name for the Fix Version field of the test execution issue.
     */
    private String version;
    /**
     * A revision for the revision custom field.
     */
    private String revision;
    /**
     * The username for the Jira user who executed the tests.
     */
    private String user;
    /**
     * The start date for the test execution issue.
     */
    private String startDate;
    /**
     * The finish date for the test execution issue.
     */
    private String finishDate;
    /**
     * The test plan key for associating the test execution issue.
     */
    private String testPlanKey;
    /**
     * The test environments for the test execution issue.
     */
    private List<String> testEnvironments = new ArrayList<>();

    /**
     * Add a test environment to the list of test environments. The provided environment string is modified such that
     * it will be displayed correctly in Xray (e.g. whitespace will be removed).
     *
     * @param environment a test environment
     */
    public void addTestEnvironment(String environment) {
        // Xray interprets environments containing whitespace as distinct environments.
        testEnvironments.add(environment.replaceAll("\\s+", "-").toLowerCase());
    }

    /**
     * The project key where the test execution will be created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProject() {
        return this.project;
    }

    /**
     * The summary for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSummary() {
        return this.summary;
    }

    /**
     * The description for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * The version name for the Fix Version field of the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * A revision for the revision custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRevision() {
        return this.revision;
    }

    /**
     * The username for the Jira user who executed the tests.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUser() {
        return this.user;
    }

    /**
     * The start date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStartDate() {
        return this.startDate;
    }

    /**
     * The finish date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFinishDate() {
        return this.finishDate;
    }

    /**
     * The test plan key for associating the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTestPlanKey() {
        return this.testPlanKey;
    }

    /**
     * The project key where the test execution will be created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProject(final String project) {
        this.project = project;
    }

    /**
     * The summary for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSummary(final String summary) {
        this.summary = summary;
    }

    /**
     * The description for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
        this.description = description;
    }

    /**
     * The version name for the Fix Version field of the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVersion(final String version) {
        this.version = version;
    }

    /**
     * A revision for the revision custom field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRevision(final String revision) {
        this.revision = revision;
    }

    /**
     * The username for the Jira user who executed the tests.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUser(final String user) {
        this.user = user;
    }

    /**
     * The start date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStartDate(final String startDate) {
        this.startDate = startDate;
    }

    /**
     * The finish date for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFinishDate(final String finishDate) {
        this.finishDate = finishDate;
    }

    /**
     * The test plan key for associating the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTestPlanKey(final String testPlanKey) {
        this.testPlanKey = testPlanKey;
    }

    /**
     * The test environments for the test execution issue.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTestEnvironments(final List<String> testEnvironments) {
        this.testEnvironments = testEnvironments;
    }
}
