/*
 * Decompiled with CFR 0.152.
 */
package de.qytera.qtaf.xray.repository.xray;

import de.qytera.qtaf.core.QtafFactory;
import de.qytera.qtaf.core.config.exception.MissingConfigurationValueException;
import de.qytera.qtaf.core.io.DirectoryHelper;
import de.qytera.qtaf.core.log.Logger;
import de.qytera.qtaf.http.RequestBuilder;
import de.qytera.qtaf.http.WebService;
import de.qytera.qtaf.xray.repository.xray.XrayCucumberRepository;
import de.qytera.qtaf.xray.repository.xray.XrayEndpoint;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;

public class XrayCucumberRepositoryCloud
implements XrayCucumberRepository,
XrayEndpoint {
    private static final Logger logger = QtafFactory.getLogger();

    @Override
    public String getFeatureFileDefinition(String[] testIDs) {
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        try {
            ZipInputStream zis = this.getZipInputStreamFromAPIResponse(keys);
            zis.getNextEntry();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int content = zis.read();
            while (content != -1) {
                outputStream.write(content);
                content = zis.read();
            }
            zis.closeEntry();
            zis.close();
            String content2 = outputStream.toString(StandardCharsets.UTF_8);
            outputStream.close();
            return content2;
        }
        catch (Exception e) {
            logger.error((Throwable)e, new Object[0]);
            return "";
        }
    }

    private ZipInputStream getZipInputStreamFromAPIResponse(String keys) throws URISyntaxException, MissingConfigurationValueException {
        RequestBuilder request = WebService.buildRequest((URI)this.getURIExportFeatureFiles(keys));
        request.getBuilder().header("Authorization", (Object)this.getXrayAuthorizationHeaderValue()).accept(new String[]{"application/zip"});
        Response response = WebService.get((RequestBuilder)request);
        InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
        return new ZipInputStream(inputStream);
    }

    private URI getURIExportFeatureFiles(String keys) throws URISyntaxException {
        return new URI(String.format("%s/export/cucumber?keys=%s", this.getXrayURL(), keys));
    }

    public List<String> getFeatureFileDefinitions(String[] testIDs) throws IOException, URISyntaxException, MissingConfigurationValueException {
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        ArrayList<String> features = new ArrayList<String>();
        ZipInputStream zis = this.getZipInputStreamFromAPIResponse(keys);
        while (zis.getNextEntry() != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int content = zis.read();
            while (content != -1) {
                outputStream.write(content);
                content = zis.read();
            }
            zis.closeEntry();
            features.add(outputStream.toString(StandardCharsets.UTF_8));
            outputStream.close();
        }
        zis.close();
        return features;
    }

    public void getAndStoreFeatureFileDefinitions(String[] testIDs, String dir) throws IOException, URISyntaxException, MissingConfigurationValueException {
        ZipEntry ze;
        String keys = StringUtils.join((Object[])testIDs, (String)";");
        ZipInputStream zis = this.getZipInputStreamFromAPIResponse(keys);
        while ((ze = zis.getNextEntry()) != null) {
            try (FileOutputStream outputStream = new FileOutputStream(DirectoryHelper.preparePath((String)(dir + "/" + ze.getName())));){
                int content = zis.read();
                while (content != -1) {
                    outputStream.write(content);
                    content = zis.read();
                }
                zis.closeEntry();
            }
        }
        zis.close();
    }
}

