// Generated by delombok at Thu Jun 27 09:18:31 UTC 2024
package de.qytera.qtaf.xray.dto.jira;

/**
 * Details about a project component.
 *
 * @param <U> the user type
 * @see <a href="https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-project-components/#api-rest-api-3-component-id-get">Get component (Jira Cloud)</a>
 * @see <a href="https://docs.atlassian.com/software/jira/docs/api/REST/9.8.0/#api/2/component-getComponent">Get component (Jira Server)</a>
 */
public class ComponentDto<U extends UserDto<?, ?>> {
    /**
     * The URL of the component.
     */
    private String self;
    /**
     * The unique identifier for the component.
     */
    private String id;
    /**
     * The unique name for the component in the project. Required when creating a component. Optional when updating a
     * component. The maximum length is 255 characters.
     */
    private String name;
    /**
     * The description for the component. Optional when creating or updating a component.
     */
    private String description;
    /**
     * The user details for the component's lead user.
     */
    private U lead;
    /**
     * The nominal user type used to determine the assignee for issues created with a component. See
     * {@link ComponentDto#getRealAssigneeType()} for details on how the type of the user, and hence the user,
     * assigned to issues is determined.
     */
    private AssigneeType assigneeType;
    /**
     * The details of the user associated with assigneeType, if any. See {@link ComponentDto#getRealAssignee()} for
     * details of the user assigned to issues created with this component.
     */
    private U assignee;
    /**
     * The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set
     * from the {@link ComponentDto#getAssigneeType()}. For example, {@link ComponentDto#getAssigneeType()} is set to
     * {@link AssigneeType#COMPONENT_LEAD} but no component lead is set.
     *
     * <p>This property is set to one of the following values:</p>
     * <dl>
     *     <dt>{@link AssigneeType#PROJECT_LEAD}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#PROJECT_LEAD} and the project lead
     *         has permission to be assigned issues in the project that the component is in.
     *     </dd>
     *     <dt>{@link AssigneeType#COMPONENT_LEAD}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#COMPONENT_LEAD} and the component
     *         lead has permission to be assigned issues in the project that the component is in.
     *     </dd>
     *     <dt>{@link AssigneeType#UNASSIGNED}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#UNASSIGNED} and Jira is configured to
     *         allow unassigned issues.
     *     </dd>
     *     <dt>{@link AssigneeType#PROJECT_DEFAULT}</dt>
     *     <dd>
     *         When none of the preceding cases are true.
     *     </dd>
     * </dl>
     */
    private AssigneeType realAssigneeType;
    /**
     * The user assigned to issues created with this component, when {@link ComponentDto#getAssigneeType()}  does not
     * identify a valid assignee.
     */
    private U realAssignee;
    /**
     * Whether a user is associated with {@link ComponentDto#getAssigneeType()}. For example, if the type is set to
     * {@link AssigneeType#COMPONENT_LEAD}, but the component lead is not set, then false is returned.
     */
    private Boolean isAssigneeTypeValid;
    /**
     * The key of the project the component is assigned to. Required when creating a component. Can't be updated.
     */
    private String project;
    /**
     * The ID of the project the component is assigned to.
     */
    private Integer projectId;


    /**
     * The user type used to determine the assignee for issues created with a component.
     *
     * <p>Default value: {@link AssigneeType#PROJECT_DEFAULT}.</p>
     */
    public enum AssigneeType {
        /**
         * The assignee to any issues created with this component is nominally the default assignee for the project
         * that the component is in.
         */
        PROJECT_DEFAULT, 
        /**
         * The assignee to any issues created with this component is nominally the lead for the component.
         */
        COMPONENT_LEAD, 
        /**
         * The assignee to any issues created with this component is nominally the lead for the project the component
         * is in.
         */
        PROJECT_LEAD, 
        /**
         * An assignee is not set for issues created with this component.
         */
        UNASSIGNED;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ComponentDto() {
    }

    /**
     * The URL of the component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelf() {
        return this.self;
    }

    /**
     * The unique identifier for the component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * The unique name for the component in the project. Required when creating a component. Optional when updating a
     * component. The maximum length is 255 characters.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * The description for the component. Optional when creating or updating a component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * The user details for the component's lead user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public U getLead() {
        return this.lead;
    }

    /**
     * The nominal user type used to determine the assignee for issues created with a component. See
     * {@link ComponentDto#getRealAssigneeType()} for details on how the type of the user, and hence the user,
     * assigned to issues is determined.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AssigneeType getAssigneeType() {
        return this.assigneeType;
    }

    /**
     * The details of the user associated with assigneeType, if any. See {@link ComponentDto#getRealAssignee()} for
     * details of the user assigned to issues created with this component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public U getAssignee() {
        return this.assignee;
    }

    /**
     * The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set
     * from the {@link ComponentDto#getAssigneeType()}. For example, {@link ComponentDto#getAssigneeType()} is set to
     * {@link AssigneeType#COMPONENT_LEAD} but no component lead is set.
     *
     * <p>This property is set to one of the following values:</p>
     * <dl>
     *     <dt>{@link AssigneeType#PROJECT_LEAD}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#PROJECT_LEAD} and the project lead
     *         has permission to be assigned issues in the project that the component is in.
     *     </dd>
     *     <dt>{@link AssigneeType#COMPONENT_LEAD}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#COMPONENT_LEAD} and the component
     *         lead has permission to be assigned issues in the project that the component is in.
     *     </dd>
     *     <dt>{@link AssigneeType#UNASSIGNED}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#UNASSIGNED} and Jira is configured to
     *         allow unassigned issues.
     *     </dd>
     *     <dt>{@link AssigneeType#PROJECT_DEFAULT}</dt>
     *     <dd>
     *         When none of the preceding cases are true.
     *     </dd>
     * </dl>
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AssigneeType getRealAssigneeType() {
        return this.realAssigneeType;
    }

    /**
     * The user assigned to issues created with this component, when {@link ComponentDto#getAssigneeType()}  does not
     * identify a valid assignee.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public U getRealAssignee() {
        return this.realAssignee;
    }

    /**
     * Whether a user is associated with {@link ComponentDto#getAssigneeType()}. For example, if the type is set to
     * {@link AssigneeType#COMPONENT_LEAD}, but the component lead is not set, then false is returned.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsAssigneeTypeValid() {
        return this.isAssigneeTypeValid;
    }

    /**
     * The key of the project the component is assigned to. Required when creating a component. Can't be updated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProject() {
        return this.project;
    }

    /**
     * The ID of the project the component is assigned to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * The URL of the component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelf(final String self) {
        this.self = self;
    }

    /**
     * The unique identifier for the component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * The unique name for the component in the project. Required when creating a component. Optional when updating a
     * component. The maximum length is 255 characters.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * The description for the component. Optional when creating or updating a component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDescription(final String description) {
        this.description = description;
    }

    /**
     * The user details for the component's lead user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLead(final U lead) {
        this.lead = lead;
    }

    /**
     * The nominal user type used to determine the assignee for issues created with a component. See
     * {@link ComponentDto#getRealAssigneeType()} for details on how the type of the user, and hence the user,
     * assigned to issues is determined.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAssigneeType(final AssigneeType assigneeType) {
        this.assigneeType = assigneeType;
    }

    /**
     * The details of the user associated with assigneeType, if any. See {@link ComponentDto#getRealAssignee()} for
     * details of the user assigned to issues created with this component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAssignee(final U assignee) {
        this.assignee = assignee;
    }

    /**
     * The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set
     * from the {@link ComponentDto#getAssigneeType()}. For example, {@link ComponentDto#getAssigneeType()} is set to
     * {@link AssigneeType#COMPONENT_LEAD} but no component lead is set.
     *
     * <p>This property is set to one of the following values:</p>
     * <dl>
     *     <dt>{@link AssigneeType#PROJECT_LEAD}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#PROJECT_LEAD} and the project lead
     *         has permission to be assigned issues in the project that the component is in.
     *     </dd>
     *     <dt>{@link AssigneeType#COMPONENT_LEAD}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#COMPONENT_LEAD} and the component
     *         lead has permission to be assigned issues in the project that the component is in.
     *     </dd>
     *     <dt>{@link AssigneeType#UNASSIGNED}</dt>
     *     <dd>
     *         When {@link ComponentDto#getAssigneeType()} is {@link AssigneeType#UNASSIGNED} and Jira is configured to
     *         allow unassigned issues.
     *     </dd>
     *     <dt>{@link AssigneeType#PROJECT_DEFAULT}</dt>
     *     <dd>
     *         When none of the preceding cases are true.
     *     </dd>
     * </dl>
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRealAssigneeType(final AssigneeType realAssigneeType) {
        this.realAssigneeType = realAssigneeType;
    }

    /**
     * The user assigned to issues created with this component, when {@link ComponentDto#getAssigneeType()}  does not
     * identify a valid assignee.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRealAssignee(final U realAssignee) {
        this.realAssignee = realAssignee;
    }

    /**
     * Whether a user is associated with {@link ComponentDto#getAssigneeType()}. For example, if the type is set to
     * {@link AssigneeType#COMPONENT_LEAD}, but the component lead is not set, then false is returned.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIsAssigneeTypeValid(final Boolean isAssigneeTypeValid) {
        this.isAssigneeTypeValid = isAssigneeTypeValid;
    }

    /**
     * The key of the project the component is assigned to. Required when creating a component. Can't be updated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProject(final String project) {
        this.project = project;
    }

    /**
     * The ID of the project the component is assigned to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setProjectId(final Integer projectId) {
        this.projectId = projectId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ComponentDto)) return false;
        final ComponentDto<?> other = (ComponentDto<?>) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$isAssigneeTypeValid = this.getIsAssigneeTypeValid();
        final java.lang.Object other$isAssigneeTypeValid = other.getIsAssigneeTypeValid();
        if (this$isAssigneeTypeValid == null ? other$isAssigneeTypeValid != null : !this$isAssigneeTypeValid.equals(other$isAssigneeTypeValid)) return false;
        final java.lang.Object this$projectId = this.getProjectId();
        final java.lang.Object other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) return false;
        final java.lang.Object this$self = this.getSelf();
        final java.lang.Object other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$lead = this.getLead();
        final java.lang.Object other$lead = other.getLead();
        if (this$lead == null ? other$lead != null : !this$lead.equals(other$lead)) return false;
        final java.lang.Object this$assigneeType = this.getAssigneeType();
        final java.lang.Object other$assigneeType = other.getAssigneeType();
        if (this$assigneeType == null ? other$assigneeType != null : !this$assigneeType.equals(other$assigneeType)) return false;
        final java.lang.Object this$assignee = this.getAssignee();
        final java.lang.Object other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) return false;
        final java.lang.Object this$realAssigneeType = this.getRealAssigneeType();
        final java.lang.Object other$realAssigneeType = other.getRealAssigneeType();
        if (this$realAssigneeType == null ? other$realAssigneeType != null : !this$realAssigneeType.equals(other$realAssigneeType)) return false;
        final java.lang.Object this$realAssignee = this.getRealAssignee();
        final java.lang.Object other$realAssignee = other.getRealAssignee();
        if (this$realAssignee == null ? other$realAssignee != null : !this$realAssignee.equals(other$realAssignee)) return false;
        final java.lang.Object this$project = this.getProject();
        final java.lang.Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ComponentDto;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $isAssigneeTypeValid = this.getIsAssigneeTypeValid();
        result = result * PRIME + ($isAssigneeTypeValid == null ? 43 : $isAssigneeTypeValid.hashCode());
        final java.lang.Object $projectId = this.getProjectId();
        result = result * PRIME + ($projectId == null ? 43 : $projectId.hashCode());
        final java.lang.Object $self = this.getSelf();
        result = result * PRIME + ($self == null ? 43 : $self.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $lead = this.getLead();
        result = result * PRIME + ($lead == null ? 43 : $lead.hashCode());
        final java.lang.Object $assigneeType = this.getAssigneeType();
        result = result * PRIME + ($assigneeType == null ? 43 : $assigneeType.hashCode());
        final java.lang.Object $assignee = this.getAssignee();
        result = result * PRIME + ($assignee == null ? 43 : $assignee.hashCode());
        final java.lang.Object $realAssigneeType = this.getRealAssigneeType();
        result = result * PRIME + ($realAssigneeType == null ? 43 : $realAssigneeType.hashCode());
        final java.lang.Object $realAssignee = this.getRealAssignee();
        result = result * PRIME + ($realAssignee == null ? 43 : $realAssignee.hashCode());
        final java.lang.Object $project = this.getProject();
        result = result * PRIME + ($project == null ? 43 : $project.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ComponentDto(self=" + this.getSelf() + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", lead=" + this.getLead() + ", assigneeType=" + this.getAssigneeType() + ", assignee=" + this.getAssignee() + ", realAssigneeType=" + this.getRealAssigneeType() + ", realAssignee=" + this.getRealAssignee() + ", isAssigneeTypeValid=" + this.getIsAssigneeTypeValid() + ", project=" + this.getProject() + ", projectId=" + this.getProjectId() + ")";
    }
}
