// Generated by delombok at Thu Jun 27 09:18:31 UTC 2024
package de.qytera.qtaf.xray.entity;

import de.qytera.qtaf.core.log.model.collection.TestScenarioLogCollection;
import de.qytera.qtaf.xray.config.XrayStatusHelper;
import java.util.ArrayList;
import java.util.List;

/**
 * Xray test iteration result entity.
 *
 * @see <a href="https://docs.getxray.app/display/XRAY/Import+Execution+Results#ImportExecutionResults-XrayJSONSchema">Xray Server JSON format</a>
 * @see <a href="https://docs.getxray.app/display/XRAYCLOUD/Using+Xray+JSON+format+to+import+execution+results">Xray Cloud JSON format</a>
 */
public abstract class XrayIterationResultEntity {
    /**
     * An array of parameters along with their values.
     */
    private List<XrayIterationParameterEntity> parameters = new ArrayList<>();
    /**
     * The status for the iteration (PASS, FAIL, EXECUTING, TO DO, custom statuses ...).
     */
    private final String status;
    /**
     * An array of step results (for Manual tests).
     */
    private List<XrayManualTestStepResultEntity> steps = new ArrayList<>();

    /**
     * Creates a new {@link XrayIterationResultEntity} with a given result status.
     *
     * @param status the status
     */
    protected XrayIterationResultEntity(TestScenarioLogCollection.Status status) {
        this.status = XrayStatusHelper.statusToText(status);
    }

    /**
     * An array of parameters along with their values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<XrayIterationParameterEntity> getParameters() {
        return this.parameters;
    }

    /**
     * The status for the iteration (PASS, FAIL, EXECUTING, TO DO, custom statuses ...).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStatus() {
        return this.status;
    }

    /**
     * An array of step results (for Manual tests).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<XrayManualTestStepResultEntity> getSteps() {
        return this.steps;
    }

    /**
     * An array of parameters along with their values.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setParameters(final List<XrayIterationParameterEntity> parameters) {
        this.parameters = parameters;
    }

    /**
     * An array of step results (for Manual tests).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSteps(final List<XrayManualTestStepResultEntity> steps) {
        this.steps = steps;
    }
}
